<div class="col-lg-12 mt-3">
    <div class="card">
        <div class="card-body">
            <div class="table table-striped table-hover">
                <table class="table table-responsive" id="destaques-table">
                    <thead>
                    <tr>
                        <th>Foto</th>
                        <th>Titulo</th>
                        <th>Status</th>
                        <th>Ações</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $destaques; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $destaque): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><img src="/uploads/destaques/sm<?php echo $destaque->foto; ?>" class="img-fluid"></td>
                            <td><?php echo $destaque->titulo; ?></td>
                            <td>
                                <span class="badge <?php echo e($destaque->statu_id == 1 ? ' badge-success':' badge-warning'); ?>"><?php echo e($destaque->status->nome); ?></span>

                            </td>
                            <td>
                                <?php echo Form::open(); ?>

                                <div class="btn-toolbar" role="toolbar">
                                    <div class='btn-group'>
                                        <a title="Adicionar Fotos" href="/admin/destaquesfotos/<?php echo e($destaque->id); ?>"  class='btn btn-sm btn-light'><i class="fa fa-images"></i></a>

                                        <a title="Editar veículo" href="<?php echo route('admin.destaques.edit', [$destaque->id]); ?>"  class='btn btn-sm btn-light'><i class="fa fa-edit"></i></a>
                                        <?php if( $destaque->statu_id == 1 ): ?>
                                        <a title="Inativar veículo" href="/admin/destaques_inativa/<?php echo e(base64_encode($destaque->id)); ?>"
                                           class="btn btn-sm btn-light">
                                            <i class="fas fa-ban"></i>
                                        </a>
                                    <?php else: ?>
                                        <a title="Ativar veículo" href="/admin/destaques_ativa/<?php echo e(base64_encode($destaque->id)); ?>"
                                           class="btn btn-sm btn-light">
                                            <i class="far fa-check-circle"></i>
                                        </a>
                                    <?php endif; ?>
                                        <a title="Excluir veículo" href="#" data-bb="confirm" data-text="Tem certeza que deseja excluir este veículo: '<?php echo e($destaque->titulo); ?>'" data-href="/admin/destaques_delete/<?php echo e($destaque->id); ?>" class="btn btn-sm btn-danger"><i class="fas fa-times"></i></a>
                                    </div>
                                </div>
                                <?php echo Form::close(); ?>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="4">
                                <center>
                                    <img src="/images/caixa.gif" alt="vazio">
                                Nenhum veículo encontrado.
                                </center>
                            </td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php $__env->startSection('scripts'); ?>




    <script type="text/javascript">

        $(document).ready(function() {

            var table =  $('#destaques-table').DataTable( {
                responsive: {
                    details: {
                        display: $.fn.dataTable.Responsive.display.modal( {
                            header: function ( row ) {
                                var data = row.data();
                                return 'Detalhes do '+data[0];
                            }
                        } ),
                        renderer: $.fn.dataTable.Responsive.renderer.tableAll( {
                            tableClass: 'table'
                        } )
                    }
                },
                language: {
                    "url": "/js/pt-br.json",
                },
            });


        } );

    </script>

<?php $__env->stopSection(); ?>
<?php /**PATH D:\xamppnew\htdocs\lbus_brasil\laravel\resources\views/admin/destaques/table.blade.php ENDPATH**/ ?>