
<div class="col-lg-12">
    <div class="card">
        <div class="card-header d-flex align-items-center">
            <h3 class="h4">Fotos do Serviço</h3>
        </div>
        <div class="card-body">
        <?php if(isset($servicosfoto)): ?>
            <!-- Titulo Field -->
                <div class="form-group col-sm-6">
                    <?php echo Form::label('titulo', 'Name:'); ?>

                    <?php echo Form::text('titulo', null, ['class' => 'form-control', 'placeholder' => 'Nome da Foto']); ?>

                </div>
                <input type="hidden" value="<?php echo e($servico->id); ?>" id="servico_id" name="servico_id">
                <!-- Foto Field -->
                <div class="form-group col-sm-6">
                    <label for="foto" class="control-label">Foto:</label>

                    <input type="file" name="foto" class="form-control" id="foto" onchange="$('#nome_arquivo').val(this.value)" style="display: none">
                    <input type="text" name="nome_arquivo" id="nome_arquivo" class="form-control"
                           value="<?= isset($servicosfoto['foto']) ? $servicosfoto['foto'] : "" ?>" disabled>
                    <input type="button" class="btn" value="Selecione um arquivo" onclick="$('#foto').click();">
                    <span class="help-block">Tamanho da imagem 800x600 pixels.</span>
                </div>

                <div class="form-group col-6">
                    <?php echo Form::label('order', 'Ordem: '); ?>


                    <?php echo Form::number('order', null, ['class' => 'form-control']); ?>

                </div>
            <?php else: ?>
                <?php echo $__env->make('admin.servicosfotos.foto_template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <?php echo Form::open(['class' => 'col-lg-12 form-row', 'files' => 'true']); ?>

                <input type="hidden" value="<?php echo e($servico_id); ?>" id="servico_id" name="servico_id">
                <?php echo Form::close(); ?>


                <div class="col-12">
                    <div class="panel-heading"><h3 class="panel-title">Selecione fotos</h3></div>
                    <div id="fine-uploader-manual-trigger"></div>
                </div>
                <div class="col-12 text-center">
                    <span class="help-block mt-2">Tamanho da imagem 800x600 pixels.</span>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<div class="col-lg-12 text-center">
    <!-- Submit Field -->
    <div class="form-group col-sm-12">
        <?php if(isset($servicosfoto)): ?>
            <?php echo Form::submit('Salvar', ['class' => 'btn btn-primary']); ?>

            <a href="/admin/servicosfotos/<?php echo e($servico->id); ?>" class="btn btn-default">Cancelar</a>
        <?php else: ?>
            <a href="/admin/servicosfotos/<?php echo e($servico_id); ?>" class="btn btn-primary">Listar imagens</a>
        <?php endif; ?>
    </div>
</div>


<?php $__env->startSection('scripts'); ?>

    <?php if(!isset($servicosfoto)): ?>
        <script>
            var token = $('input[name="_token"]').val();

            $('#fine-uploader-manual-trigger').fineUploader({
                template: 'qq-template-manual-trigger',
                request: {
                    endpoint: "/admin/servicosfotos",
                    customHeaders: {
                        'X-CSRF-TOKEN': token
                    }
                },
                thumbnails: {
                    placeholders: {
                        waitingPath: '/css/placeholders/waiting-generic.png',
                        notAvailablePath: '/css/placeholders/not_available-generic.png'
                    }
                },
                autoUpload: false,
                validation: {
                    allowedExtensions: ['jpeg', 'jpg', 'png']
                },

                callbacks: {
                    onUpload: function() {
                        var params = {
                            servico_id: $("#servico_id").val(),
                        };

                        this.setParams(params);
                    },
                }
            });

            $('#trigger-upload').click(function() {
                $('#fine-uploader-manual-trigger').fineUploader('uploadStoredFiles');
            });

        </script>

    <?php endif; ?>

<?php $__env->stopSection(); ?><?php /**PATH D:\xamppnew\htdocs\orions\resources\views/admin/servicosfotos/fields.blade.php ENDPATH**/ ?>