<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title><?php echo e($title_for_layout); ?></title>
    <?php if(isset($keywords_for_layout)): ?>
        <meta name="keywords" content="<?php echo e($keywords_for_layout); ?>">
    <?php endif; ?>
    <?php if(isset($description_for_layout)): ?>
        <meta name="description" content="<?php echo e($description_for_layout); ?>">
    <?php endif; ?>


    <!-- css -->
    <link rel="stylesheet" href="/css/bootstrap.css">

    <link rel="stylesheet" href="/css/app.css">

    <?php echo $__env->yieldContent('css'); ?>

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;600;700&display=swap"
        rel="stylesheet">

    <?php if(isset($integracoes->head)): ?>
        <?php echo $integracoes->head; ?>

    <?php endif; ?>
</head>

<body>
    <?php if(isset($integracoes->abertura)): ?>
        <?php echo $integracoes->abertura; ?>

    <?php endif; ?>
    <header>

        <div class="menu">

            <div class="w-100 nav_icons_container">
                <div class="nav_icons">
                    <a href=""><i class="fas fa-phone fa-4x fa-rotate-90"></i></a>
                    <?php echo isset($configuracoes->instagram)
                        ? '<a href="' . $configuracoes->instagram . '"><i class="fab fa-instagram fa-5x"></i></a>'
                        : ''; ?>

                    <?php echo isset($configuracoes->facebook)
                        ? '<a href="' . $configuracoes->facebook . '"><i class="fab fa-facebook fa-5x"></i></a>'
                        : ''; ?>

                    <?php echo isset($configuracoes->linkedin)
                        ? '<a href="' . $configuracoes->linkedin . '"><i class="fab fa-linkedin fa-5x"></i></a>'
                        : ''; ?>

                </div>
            </div>

            <nav class="navbar navbar-expand-lg">
                <div class="container-fluid nav_px">
                    <a href="/"><img
                            src="/uploads/configuracoes/<?php echo e(isset($configuracoes) ? $configuracoes['logo'] : ''); ?>"
                            style=" padding-bottom: 50px" alt="Logotipo <?php echo e($title_for_layout); ?>" class="img-fluid "></a>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                        data-bs-target="#navbarNavAltMarkup" aria-controls="navbarNavAltMarkup" aria-expanded="false"
                        aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    <div class="collapse navbar-collapse  " id="navbarNavAltMarkup">
                        <div class="navbar-nav w-100 d-flex justify-content-around z-3 position-relative bg-white">
                            <?php $__currentLoopData = $paginas_menu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(sizeof($menu->paginas) != 0): ?>
                                    <li class="nav-item dropdown">
                                        <a class="nav-link center truncate" href="#" role="button"
                                            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            <?php echo e($menu->nome); ?>

                                        </a>
                                        <i class="fas fa-caret-down fa-lg text-center w-100 text-danger "></i>
                                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                                            <?php $__currentLoopData = $menu->paginas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $submenu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <a class="dropdown-item"
                                                    href="<?php echo e($submenu->slug); ?>"><?php echo e($submenu->nome); ?></a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </li>
                                <?php else: ?>
                                    <li class="nav-item">
                                        <a class="nav-link truncate" href="<?php echo e($menu->slug); ?>"><?php echo e($menu->nome); ?></a>
                                    </li>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <li class="nav-item dropdown" style="width: 15%;">
                                <a class="nav-link center truncate" href="#" role="button"
                                    data-bs-toggle="dropdown" aria-expanded="false">
                                    Contabilidade
                                </a>

                                <i class="fas fa-caret-down fa-lg text-center w-100 text-danger "></i>
                                <ul class="dropdown-menu">
                                    <?php $__currentLoopData = $servicos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $servico): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><a class="dropdown-item" href="#">Assessoria Contábil</a></li>
                                        <li><a class="dropdown-item" href="#">Regularização de Obras</a></li>
                                        <li><a class="dropdown-item" href="#">Declaração de Imposto de Renda</a>
                                        </li>
                                        <li><a class="dropdown-item" href="#"> Folha de Pagamento</a></li>
                                        
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </ul>
                            </li>

                            <li class="nav-link truncate" aria-current="page"><a href="#">Advocacia</a></li>

                            <li class="nav-item dropdown" style="width: 15%;">
                                <a class="nav-link center truncate" href="#" role="button"
                                    data-bs-toggle="dropdown" aria-expanded="false">
                                    Sua Empresa
                                </a>

                                <i class="fas fa-caret-down fa-lg text-center w-100 text-danger "></i>
                                <ul class="dropdown-menu w-100">
                                    <?php $__currentLoopData = $servicos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $servico): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><a class="dropdown-item" href="#">Abertura de Empresa</a></li>
                                        <li><a class="dropdown-item" href="#">Gerenciamento de Empresa</a></li>
                                        <li><a class="dropdown-item" href="#">BPO Financeiro</a></li>
                                        <li><a class="dropdown-item" href="#"> Certificado Digital</a></li>
                                        
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </ul>
                            </li>
                            <li class="nav-link truncate" aria-current="page"><a href="#">Contato</a></li>
                        </div>
                    </div>
                </div>
            </nav>


        </div>

    </header>
    <section>
        <div class="container-fluid">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </section>
    <footer>
        <div class="container-fluid fundo">
            <div class="row pt-5 pb-4 pad-px">
                <div class="col-12 col-md-4 my-auto d-flex justify-content-center">

                    <div class="col-12 col-md-10">
                        <h5><strong>Sobre a empresa</strong></h5>
                        <br>
                        <p class="pb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer eu tortor
                            libero. Quisque ac gravida libero, a porttitor est. In id orci tortor. Nullam
                            pellentesque augue sed augue feugiat auctor. <br><br> Lorem ipsum dolor sit amet,
                            consectetur adipiscing elit. Integer eu tortor libero. </p>

                    </div>

                </div>
                <div class="col-12 col-md-4 my-auto d-flex justify-content-center">
                    <div class="d-flex justify-content-center contact">

                        <div class="col-12 col-md-10">
                            <h5><strong>Contate-nos</strong></h5>
                            <br>
                            <?php if(sizeof($telefone) > 0): ?>
                                <?php $__currentLoopData = $telefone; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <h6 class="pb-2 row">
                                        <a href="tel:<?php echo e($key); ?>" class="d-block">
                                            <div class="col-md-2 icon">
                                                <i class="fas fa-phone fa-lg fa-rotate-90"></i>
                                            </div>

                                            <div class="col-md-10 ">
                                                <?php echo e($tel); ?>

                                            </div>

                                        </a>
                                    </h6>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            
                            <h6 class="pb-2 row">
                                <a href="mail:#" class="d-block">

                                    <div class="col-md-2 icon">
                                        <i class="fas fa-envelope fa-lg"></i>

                                    </div>

                                    <div class="col-md-10">
                                        contato@orgmercurio.com.br
                                    </div>

                                </a>
                            </h6>
                            
                            <br><br>
                            <h5><strong> Siga-nos</strong></h5>

                            <div class="pb-2 icon">
                                <br>
                                <?php echo isset($configuracoes->instagram)
                                    ? '<a href="' . $configuracoes->instagram . '"><i class="fab fa-instagram  fa-lg icon2"></i></a>'
                                    : ''; ?>

                                <?php echo isset($configuracoes->facebook)
                                    ? '<a href="' . $configuracoes->facebook . '"><i class="fab fa-facebook fa-lg icon2"></i></a>'
                                    : ''; ?>

                                <?php echo isset($configuracoes->linkedin)
                                    ? '<a href="' . $configuracoes->linkedin . '"><i class="fab fa-linkedin fa-lg icon2"></i></a>'
                                    : ''; ?>


                            </div>
                        </div>
                    </div>

                </div>

                <div class="col-12 col-md-4 my-auto d-flex justify-content-center">
                    <div class="d-flex justify-content-center">

                        <div class="col-12 col-md-10">
                            <h5><strong>Venha até nós:</strong></h5>
                            <br>
                            <h6 class="pb-2 row">
                                <div class="col-md-1 icon">
                                    <i class="fas fa-map-marker-alt fa-2x"></i>
                                </div>

                                <div class="col-md-8 font20">
                                    <?php echo isset($configuracoes->rua) ? $configuracoes->rua : ''; ?>, <?php echo isset($configuracoes->numero) ? $configuracoes->numero : ''; ?> - <?php echo isset($configuracoes->bairro) ? $configuracoes->bairro : ''; ?>,
                                    <?php echo isset($configuracoes->cidade) ? $configuracoes->cidade : ''; ?> - <?php echo isset($configuracoes->estado) ? $configuracoes->estado : ''; ?>, 12570-000
                                </div>


                            </h6>
                            <div class="pb-2">
                                <?php echo isset($configuracoes->iframe) ? $configuracoes->iframe : ''; ?>

                                <iframe
                                    src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3676.8592894727567!2d-45.232385384507005!3d-22.844694841402767!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x94ccc366c1cc13cd%3A0x2eec4f4ca2dff78c!2zT3JnYW5pemHDp8OjbyBNZXJjw7pyaW8!5e0!3m2!1spt-BR!2sbr!4v1681243572859!5m2!1spt-BR!2sbr"
                                    style="border:0;" allowfullscreen="" loading="lazy"
                                    referrerpolicy="no-referrer-when-downgrade"></iframe>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
        </div>
        <div class="col-12">
            <div class="col-12 text-center font15 copyright">

                <p> ORGANIZAÇÃO MERCÚRIO - TODOS OS DIREITOS RESERVADOS | DESENVOLVIDO POR <a
                        href="https://www.orions.com.br" target="_blank"> ORIONS </p>
            </div>
        </div>
        </div>
    </footer>

    <!-- js -->
    <script src="/js/bootstrap.js"></script>

    <script src="/js/app.js"></script>

    <?php echo $__env->yieldContent('script'); ?>

    <!-- FontAwesome CSS - loading as last, so it doesn't block rendering-->
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.1/css/all.css"
        integrity="sha384-fnmOCqbTlWIlj8LyTjo7mOUStjsKC4pOpQbqyi7RrhN7udi9RwhKkMHpvLbHG9Sr" crossorigin="anonymous">
</body>

</html>
<?php /**PATH D:\xamppnew\htdocs\orions\laravel\resources\views/app.blade.php ENDPATH**/ ?>