@extends('app')

@section('content')
    <div class="row mb-5">
        <div class="col-12 p-0">
            <img src="/uploads/servicos/{{ $servico->foto }}" class="img-fluid servico">
        </div>
    </div>
    <div class="row">
        <div class="col-12 col-md-10 offset-md-1 text-center">
            <h5 class="text-blue mb-0 text-uppercase"><strong>{{ $servico->nome }}</strong></h5>
            <p class="w-35 d-inline-block line text-uppercase">{{ $servico->subtitulo }}</p>
            <span class="clearfix"></span>
            <span class="bar mt-2"></span>
        </div>
    </div>
    <div class="row mt-4">
        <div class="col-12 col-md-10 offset-md-1">
            {!! $servico->descricao !!}
        </div>
    </div>
    <div class="row mb-3">
        <div class="col-12 col-md-10 offset-md-1 text-center">
            @foreach($servico->servicosfotos as $foto)
                <a href="/uploads/servicosfotos/{{ $foto->foto }}" data-lightbox="gallery"><img src="/uploads/servicosfotos/sm{{ $foto->foto }}" class="img-fluid px-2 py-1 py-md-4" alt="{{ $foto->titulo }}"></a>

            @endforeach
        </div>
    </div>
@endsection
