<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
  <head>
    <meta charset="utf-8">
    <title>{{ config('app.name') }}</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Google fonts - Poppins -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,700">
    <!-- Custom stylesheet - for your changes-->
    <link rel="stylesheet" href="../css/admin.css">
    @yield('css')
  </head>
    <body>
        @if (!Auth::guest())
        <div class="page home-page">
            <!-- Main Navbar-->
            <header class="header">
                <nav class="navbar">
                    <!-- Search Box-->
                    <div class="search-box">
                        <button class="dismiss">
                            <svg class="svg-icon svg-icon-heavy">
                                <use xlink:href="#close-1"> </use>
                            </svg>
                        </button>
                        <form id="searchForm" action="#" role="search">
                            <input class="form-control" type="search" placeholder="What are you looking for...">
                        </form>
                    </div>
                    <div class="container-fluid w-100">
                        <div class="navbar-holder d-flex align-items-center justify-content-between w-100">
                            <!-- Navbar Header-->
                            <div class="navbar-header">
                                <!-- Navbar Brand --><a class="navbar-brand" href="{{ url('/admin') }}">
                                    <div class="brand-text d-none d-lg-inline-block"><img class="logo" src="../uploads/configuracoes/{{ isset($configuracoes)? $configuracoes['logo'] : '' }}"></div>
                                    <div class="brand-text d-none d-sm-inline-block d-lg-none"><img class="logo" src="../uploads/configuracoes/{{ isset($configuracoes)? $configuracoes['logo'] : '' }}"></div>
                                    @yield('logo')
                                </a>
                                <!-- Toggle Button--><a class="menu-btn active" id="toggle-btn" href="#"><span></span><span></span><span></span></a>
                            </div>
                            <!-- Navbar Menu -->
                            <ul class="nav-menu list-unstyled d-flex flex-md-row align-items-md-center">

                                <!-- Logout    -->
                                <li class="nav-item">
                                    <a href="{!! url('/logout') !!}" class="nav-link logout"  onclick="event.preventDefault(); document.getElementById('logout-form').submit()"> <span class="d-none d-sm-inline">Sair</span><i class="fas fa-sign-out-alt"></i></a>
                                </li>
                                <form id="logout-form" action="{{ url('/logout') }}" method="POST" style="display: none;">
                                    {{ csrf_field() }}
                                </form>
                            </ul>
                        </div>
                    </div>
                </nav>
            </header>
            <div class="page-content d-flex">
                @include('layouts.sidebar')

                <div class="content-inner">

                    @yield('content')

                </div>
                <!-- Main Footer -->
                <footer class="main-footer" style="max-height: 100px;text-align: right">
                    <strong>Copyright © {{date('Y')}} {{isset($configuracoes)? $configuracoes['nome_aplicacao'] : ''}}</strong> v2.0
                </footer>
            </div>
        </div>
        @endif

        <script src="/js/admin.js"></script>
        <script type="text/javascript">
            $(document).ready(function() {
                $('.alert').delay(4000).hide('slow');
            });

        </script>
        @yield('scripts')

        <!-- FontAwesome CSS - loading as last, so it doesn't block rendering-->
        <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.1/css/all.css" integrity="sha384-fnmOCqbTlWIlj8LyTjo7mOUStjsKC4pOpQbqyi7RrhN7udi9RwhKkMHpvLbHG9Sr" crossorigin="anonymous">
        {{-- lottie --}}
        <script src="https://unpkg.com/@lottiefiles/lottie-player@latest/dist/lottie-player.js"></script>
        <div class="modal fade bs-example-modal-sm" tabindex="-1" id="modal1" role="dialog" aria-hidden="true"></div>
    </body>
</html>
