@extends('app')
@section('content')
    {{-- Banner Rotativo --}}

    <div class="row">

        <div id="carouselExampleInterval" class="carousel slide position-relative" data-bs-ride="carousel">
            <div class="carousel-indicators">
                @for ($i = 0; $i < sizeof($banners); $i++)
                    <button type="button" data-bs-target="#carouselExampleInterval" data-bs-slide-to="<?= $i ?>"
                        class="<?= $i == 0 ? ' active' : '' ?>" aria-current="true"></button>
                @endfor
            </div>
            <div class="carousel-inner">
                @for ($i = 0; $i < sizeof($banners); $i++)
                    <div class="carousel-item <?= $i == 0 ? ' active' : '' ?>">
                        @if (!empty($banners[$i]->url))
                            <a href="{{ $banners[$i]->url }}" target="_blank"><img
                                    src="uploads/banners/{{ $banners[$i]->foto }}" class="d-block w-100"
                                    alt="{{ $banners[$i]->nome }}"></a>
                        @else
                            <img src="uploads/banners/{{ $banners[$i]->foto }}" class="d-block w-100"
                                alt="{{ $banners[$i]->nome }}">
                        @endif
                    </div>
                @endfor

            </div>
            <div class="banner"></div>

            <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleInterval"
                data-bs-slide="prev">
                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Anterior</span>
            </button>
            <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleInterval"
                data-bs-slide="next">
                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Próximo</span>
            </button>

        </div>
    </div>
    {{-- Bloco 1 --}}

    <div class="row col-12 pt-5 ms-5 ps-5">
        <form class="col-12 col-md-10 row gap-4 ps-3">
            <div class="col-12 col-md-3 mb-3">
                <label class="form-label text-nowrap">BUSCA RÁPIDA</label>
                <input type="text" class="form-control">
            </div>
            <div class="col-12 col-md-3 mb-3">
                <label class="form-label">CATEGORIA</label>
                <input type="text" class="form-control">
            </div>
            <div class="col-12 col-md-2 mb-3">
                <label class="form-label ">ANO</label>
                <input type="text" class="form-control">
            </div>
            <div class="col-12 col-md-2 mb-3">
                <label class="form-label">VALOR</label>
                <input type="text" class="form-control">
            </div>
            <div class="col-12 col-md-1 search">
                <button type="submit" class="btn btn-primary float-end blue">BUSCAR</button>

            </div>

        </form>
    </div>
    <br>
    <div class="col-12 mt-5">
        <div class="col-12 w-100 col-md-10 ">
            <div class=' d-flex flex-wrap justify-content-center font18 px-5 gap-5'>
                @if (sizeof($blocos) > 0)
                    @foreach ($blocos as $bloco)
                        <div class=" col-12 col-md-2 position-relative d-block effect mb-5 ">
                            {!! !empty($bloco->link)
                                ? '<a href="' .
                                    $bloco->link .
                                    '"><img src="uploads/blocos/' .
                                    $bloco->icone .
                                    '" class="w-100" alt="' .
                                    $bloco->titulo .
                                    '"> '
                                : '<img src="uploads/blocos/' . $bloco->icone . '" class="w-100" alt="' . $bloco->titulo . '">' !!}
                            <div
                                class="text-uppercase legend <?= empty($bloco->descricao) ? 'd-flex justify-content-center align-items-center' : '' ?> ">
                                <spam class="d-flex justify-content-center <?= !empty($bloco->descricao) ? 'pt-2' : '' ?>">
                                    {{ $bloco->titulo }}</spam>
                                @if ($bloco->descricao)
                                    <spam class="d-flex justify-content-center"><small> {{ $bloco->descricao }} </small>
                                    </spam>
                                @endif
                            </div>



                            <p class="click">Clique aqui</p>
                            </a>
                        </div>
                    @endforeach
                @endif


            </div>
        </div>
        <br>
        <div class="col-12  d-flex justify-content-center font18 my-5">

            <div class='col-12 col-md-11 d-flex  flex-wrap justify-content-start px-5'>
                <div class="col-12 d-flex justify-content-center pb-3">
                    <h4 class="text-uppercase orange"><strong>Veículos em destaque</strong></h4>

                </div>
                @if (sizeof($destaques) > 0)
                    @foreach ($destaques as $destaque)
                        <div class='col-12 col-md-3 d-flex justify-content-center py-4 px-4 bg-gray'>
                            <a href="{{ $destaque->link }}">
                                <div class="card col-12 col-md-11 effect w-100">
                                    <img src="uploads/destaques/{{ $destaque->foto }}" class="card-img-top w-100"
                                        alt="{{ $destaque->titulo }}">
                                    <div class="card-body">
                                        <h5 class="card-title orange mt-1 text-uppercase"><strong>Modelo</strong></h5>
                                        <p class="card-text">XXXXXXXX</p>
                                        <h5 class="card-title orange mt-1 text-uppercase"><strong>Ano</strong></h5>
                                        <p class="card-text">XXXXXXXX</p>
                                        <h5 class="card-title orange mt-1 text-uppercase"><strong>Valor</strong></h5>
                                        <p class="card-text">XXXXXXXX</p>

                                        <div class="col-12 d-flex justify-content-center pt-5">
                                            <a href="/veiculos/{{ $destaque->id }}" class="btn btn-light orange border">Saiba mais</a>

                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>
                    @endforeach
                @endif

            </div>

        </div>
    </div>
@endsection
