<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>Orions</title>

    <!-- Scripts -->
    <script src="{{ asset('js/app.js') }}" defer></script>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">

    <!-- Styles -->
    <link href="{{ asset('css/app.css') }}" rel="stylesheet">
</head>
<body>
    <div id="app">
        <nav class=" navbar navbar-expand-md navbar-light bg shadow-sm">
            <div class="container">
                <div class="navbar-brand">
                   <strong class="text-white"> {{ __('Orions Sites e Host') }} </strong>
                </div>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="{{ __('Toggle navigation') }}">
                    <span class="navbar-toggler-icon"></span>
                </button>

                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                    <!-- Left Side Of Navbar -->
                    <ul class="navbar-nav me-auto">

                    </ul>

                </div>
            </div>
        </nav>
        <main class="py-4">
            @if ($message = Session::get('success'))
            @php $img = Session::get('img') @endphp
            <div class="alert alert-success alert-dismissible fade show mb-2" role="alert">
                {{ $message }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>

        @endif
<div class="container">

    <div class="row justify-content-center">
        <div class="col-md-12">
<div class="row grid gap-0 column-gap-5 middle">
        <div class="col-md-4 p-2 g-col-6">
            <br>
            <div>
                <div><h4><strong>{{ __('Imagem Atual:') }}</strong></h4></div>
                <br>
                <div>
                    {{-- @php
                        $teste = "aviso_orions/".$img;
                        dd($teste);
                    @endphp --}}
                    <img class="img-thumbnail" src="aviso_orions/{{$img}}"/>
                </div>
            </div>
        </div>
        <div class="col-md-5 middle ms-5">


            {!! Form::open(['method' => 'post', 'enctype' => "multipart/form-data"]) !!}
                @csrf

                <div  class="mb-3">
                    <label for="formFile" class="form-label"><h4><strong>{{ __('Atualizar Imagem:') }}</strong></h4></label>
                    <input type="file" name="image" class="form-control @error('image') is-invalid @enderror">
                    @error('image')
                        <span class="text-danger">{{ $message }}</span>
                    @enderror
<br>
                        <button type="submit" class="btn btn-login"><strong>ATUALIZAR</button>

                </div>
                {!! Form::close() !!}

        </div>
    </div>
    </div>
</div>
</div>
</main>
<footer class="bg login- text-white fixed-bottom w-100">
    <div class="container-fluid">
        <div class="row footer-login">
            <div class="col-12 text-center">
                <p class="orions mb-0"><small>{{isset($configuracoes)? $configuracoes['nome_aplicacao'] : ''}} &copy; {{date('Y')}} | Desenvolvido por <a href="https://www.orions.com.br/"  target="_blank" class="text-white">Orions Sites</a></small></p>
            </div>
        </div>
    </div>
</footer>
</div>
</body>
</html>
