@extends('layouts.login')
@section('content')

    <div class="col-12 col-lg-4 offset-lg-4 col-md-6 offset-md-3 login">
        <br>
        <h3 class="login-box-msg">Digite o email para redefinir a senha</h3>
<br>
        @if (session('status'))
            <div class="alert alert-success">
                {{ session('status') }}
            </div>
        @endif

        <form method="post" action="{{ url('/password/email') }}">
            {!! csrf_field() !!}

            <div class="form-group has-feedback {{ $errors->has('email') ? ' has-error' : '' }}">
                <input type="email" class="form-control" name="email" value="{{ old('email') }}" placeholder="Email">
                @if ($errors->has('email'))
                    <span class="help-block">
                    <strong>{{ $errors->first('email') }}</strong>
                </span>
                @endif
            </div>

            <div class="row">
                <div class="col-md-12 text-center">
                    <br>
                    <button type="submit" class="btn btn-primary pull-right">
                        <i class="fa fa-btn fa-envelope"></i> Enviar
                    </button>
                </div>
            </div>

        </form>

    </div>
@endsection
