
<div class="col-lg-12">
    <div class="card">
        <div class="card-header d-flex align-items-center">
            <h3 class="h4">Fotos do Serviço</h3>
        </div>
        <div class="card-body">
        @if(isset($servicosfoto))
            <!-- Titulo Field -->
                <div class="form-group col-sm-6">
                    {!! Form::label('titulo', 'Name:') !!}
                    {!! Form::text('titulo', null, ['class' => 'form-control', 'placeholder' => 'Nome da Foto']) !!}
                </div>
                <input type="hidden" value="{{$servico->id}}" id="servico_id" name="servico_id">
                <!-- Foto Field -->
                <div class="form-group col-sm-6">
                    <label for="foto" class="control-label">Foto:</label>

                    <input type="file" name="foto" class="form-control" id="foto" onchange="$('#nome_arquivo').val(this.value)" style="display: none">
                    <input type="text" name="nome_arquivo" id="nome_arquivo" class="form-control"
                           value="<?= isset($servicosfoto['foto']) ? $servicosfoto['foto'] : "" ?>" disabled>
                    <input type="button" class="btn" value="Selecione um arquivo" onclick="$('#foto').click();">
                    <span class="help-block">Tamanho da imagem 800x600 pixels.</span>
                </div>

                <div class="form-group col-6">
                    {!! Form::label('order', 'Ordem: ') !!}

                    {!! Form::number('order', null, ['class' => 'form-control']) !!}
                </div>
            @else
                @include('admin.servicosfotos.foto_template')

                {!! Form::open(['class' => 'col-lg-12 form-row', 'files' => 'true']) !!}
                <input type="hidden" value="{{$servico_id}}" id="servico_id" name="servico_id">
                {!! Form::close() !!}

                <div class="col-12">
                    <div class="panel-heading"><h3 class="panel-title">Selecione fotos</h3></div>
                    <div id="fine-uploader-manual-trigger"></div>
                </div>
                <div class="col-12 text-center">
                    <span class="help-block mt-2">Tamanho da imagem 800x600 pixels.</span>
                </div>
            @endif
        </div>
    </div>
</div>

<div class="col-lg-12 text-center">
    <!-- Submit Field -->
    <div class="form-group col-sm-12">
        @if(isset($servicosfoto))
            {!! Form::submit('Salvar', ['class' => 'btn btn-primary']) !!}
            <a href="/admin/servicosfotos/{{$servico->id}}" class="btn btn-default">Cancelar</a>
        @else
            <a href="/admin/servicosfotos/{{$servico_id}}" class="btn btn-primary">Listar imagens</a>
        @endif
    </div>
</div>


@section('scripts')

    @if(!isset($servicosfoto))
        <script>
            var token = $('input[name="_token"]').val();

            $('#fine-uploader-manual-trigger').fineUploader({
                template: 'qq-template-manual-trigger',
                request: {
                    endpoint: "/admin/servicosfotos",
                    customHeaders: {
                        'X-CSRF-TOKEN': token
                    }
                },
                thumbnails: {
                    placeholders: {
                        waitingPath: '/css/placeholders/waiting-generic.png',
                        notAvailablePath: '/css/placeholders/not_available-generic.png'
                    }
                },
                autoUpload: false,
                validation: {
                    allowedExtensions: ['jpeg', 'jpg', 'png']
                },

                callbacks: {
                    onUpload: function() {
                        var params = {
                            servico_id: $("#servico_id").val(),
                        };

                        this.setParams(params);
                    },
                }
            });

            $('#trigger-upload').click(function() {
                $('#fine-uploader-manual-trigger').fineUploader('uploadStoredFiles');
            });

        </script>

    @endif

@endsection