<div class="col-lg-12 mt-3">
    <div class="card">
        <div class="card-body">
            <div class="table table-striped table-hover">
                <table class="table table-responsive" id="paginas-table">
                    <thead>
                    <tr>
                        <th>Foto</th>
                        <th>Nome</th>
                        <th>Url</th>
                        <th class="none d-none">Descrição</th>
                        <th class="none d-none">Keyword</th>
                        <th class="none d-none">Meta-Descrição</th>
                        <th>Ações</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($paginas as $pagina)
                        <tr>
                            <td tabindex="0"><img src="../uploads/paginas/{!! $pagina->foto !!}" class="img-fluid"></td>

                            <td>{!! $pagina->nome !!}  <span class="badge {{ $pagina->statu_id == 1 ? ' badge-success':' badge-warning' }}">{{$pagina->status->nome}}</span></td>
                            <td> <a href="#" class="clipboard btn-link" data-copy="{!! 'http' . (isset($_SERVER['HTTPS']) ? 's' : '') . '://' . $_SERVER['HTTP_HOST'].'/'.$pagina->slug !!}" data-toggle="tooltip" data-placement="top" title="Copiar">{!! 'http' . (isset($_SERVER['HTTPS']) ? 's' : '') . '://' . $_SERVER['HTTP_HOST'].'/'.$pagina->slug !!}</a><br>

                            </td>

                            <td class="d-none">{!! $pagina->descricao !!}</td>
                            <td class="d-none">{!! $pagina->meta_keyword !!}</td>
                            <td class="d-none">{!! $pagina->meta_description !!}</td>
                            <td>
                                {!! Form::open() !!}
                                <div class="btn-toolbar" role="toolbar">
                                    <div class='btn-group'>
                                        <a title="Editar pagina" href="{!! route('admin.paginas.edit', [$pagina->id]) !!}"  class='btn btn-sm btn-light'><i class="fa fa-edit"></i></a>


                                        @if( $pagina->statu_id == 1 )
                                            <a title="Inativar pagina" href="/admin/paginas_inativa/{{base64_encode($pagina->id)}}" class="btn btn-sm btn-light"><i class="fas fa-ban"></i></a>
                                        @else
                                            <a title="Ativar pagina" href="/admin/paginas_ativa/{{base64_encode($pagina->id)}}" class="btn btn-sm btn-light"><i class="far fa-check-circle"></i></a>
                                        @endif

                                        <a title="Excluir pagina" href="#" data-bb="confirm" data-text="Tem certeza que deseja excluir este pagina: '{{$pagina->nome}}'" data-href="/admin/paginas_delete/{{$pagina->id}}" class="btn btn-sm btn-danger"><i class="fas fa-times"></i></a>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="3">
                                <center>
                                    <img src="../images/caixa.gif" alt="vazio">
                                    Nenhuma página encontrada.
                            </center>
                            </td>

                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

@section('scripts')
    <script type="text/javascript">
        $(document).ready(function() {

            var table =  $('#paginas-table').DataTable( {
                responsive: {
                    details: {
                        display: $.fn.dataTable.Responsive.display.modal( {
                            header: function ( row ) {
                                var data = row.data();
                                return 'Detalhes do '+data[0];
                            }
                        } ),
                        renderer: $.fn.dataTable.Responsive.renderer.tableAll( {
                            tableClass: 'table'
                        } )
                    }
                },
                language: {
                    "url": "/js/pt-br.json",
                },
            });


        } );

    </script>

@endsection
