<div class="col-lg-12 mt-3">
    <div class="card">
        <div class="card-body">
            <div class="table table-striped table-hover">
                <table class="table table-responsive" id="faqs-table">
                    <thead>
                    <tr>
                        <th>Nome</th>
                        <th>Pagina</th>
                        <th>Ações</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($faqs as $faq)
                        <tr>
                            <td>{!! $faq->nome !!}</td>
            <td>{!! $faq->paginas->nome !!}</td>
                            <td>
                                {!! Form::open() !!}
                                <div class="btn-toolbar" role="toolbar">
                                    <div class='btn-group'>
                                        <a title="Gerenciar Perguntas" href="/admin/perguntas/{{$faq->id}}"  class='btn btn-sm btn-light'><i class="fa fa-question"></i></a>
                                        <a title="Editar faq" href="{!! route('admin.faqs.edit', [$faq->id]) !!}"  class='btn btn-sm btn-light'><i class="fa fa-edit"></i></a>

                                        <a title="Excluir faq" href="#" data-bb="confirm" data-text="Tem certeza que deseja excluir este faq: '{{$faq->nome}}'" data-href="/admin/faqs_delete/{{$faq->id}}" class="btn btn-sm btn-danger"><i class="fas fa-times"></i></a>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="3">
                                <center>
                                    <img src="/images/caixa.gif" alt="vazio">
                                Nenhum faq encontrado.
                                </center>
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

@section('scripts')




    <script type="text/javascript">

        $(document).ready(function() {

            var table =  $('#faqs-table').DataTable( {
                 responsive: {
                                     details: {
                                         display: $.fn.dataTable.Responsive.display.modal( {
                                             header: function ( row ) {
                                                 var data = row.data();
                                                 return 'Detalhes do '+data[0];
                                             }
                                         } ),
                                         renderer: $.fn.dataTable.Responsive.renderer.tableAll( {
                                             tableClass: 'table'
                                         } )
                                     }
                                 },
                language: {
                    "url": "/js/pt-br.json",
                },
            });


        } );

    </script>

@endsection
