<script type="text/javascript">
    function getEndereco(cep) {

        function limpa_formulario_cep() {
            // Limpa valores do formulário de cep.
            $("#rua").val("");
            $("#bairro").val("");
            $("#cidade").val("");
            $("#estado").val("");
        }

        function showError(strMessage){
            $('#modal1').html('<div class="modal-dialog modal-sm">'+
                '<div class="modal-content">'+
                '<div class="modal-header">'+
                '<h4 class="modal-title" id="myModalLabel2"><i style="color:#ffd600" class="fa fa-exclamation-triangle fa-2x" aria-hidden="true"></i></h4>'+
                '<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>'+
                '</div>'+
                '<div class="modal-body">'+
                '<p>'+strMessage+'</p>'+
                '</div></div></div>');

            $('#modal1').modal('show');
        };

        //Nova variável "cep" somente com dígitos.
        var cep = cep.replace(/\D/g, '');


        //Verifica se campo cep possui valor informado.
        if (cep != "") {

            //Expressão regular para validar o CEP.
            var validacep = /^[0-9]{8}$/;

            //Valida o formato do CEP.
            if (validacep.test(cep)) {

                //Preenche os campos com "..." enquanto consulta webservice.
                $("#rua").val("...");
                $("#bairro").val("...");
                $("#cidade").val("...");
                $("#estado").val("...");


                //Consulta o webservice viacep.com.br/
                $.getJSON("//viacep.com.br/ws/" + cep + "/json/?callback=?", function (dados) {

                    if (!("erro" in dados)) {
                        //Atualiza os campos com os valores da consulta.
                        $("#rua").val(dados.logradouro);
                        $("#bairro").val(dados.bairro);
                        $("#cidade").val(dados.localidade);
                        $("#estado").val(dados.uf);

                    } //end if.
                    else {
                        //CEP pesquisado não foi encontrado.
                        limpa_formulario_cep();
                        showError("CEP não encontrado");
                    }
                });
            } //end if.
            else {
                //cep é inválido.
                limpa_formulario_cep();
                showError("Formato de CEP inválido.");
            }
        } //end if.
        else {
            //cep sem valor, limpa formulário.
            limpa_formulario_cep();
        }



    }

    $("#cep").blur(function(){
        getEndereco($("#cep").val());
    });

</script><!-- === chamada de endereço por CEP === -->
