<div class="col-lg-12 mt-3">
    <div class="card">
        <div class="card-body">
            <div class="table table-striped table-hover">
                <table class="table table-responsive" id="destaques-table">
                    <thead>
                    <tr>
                        <th>Foto</th>
                        <th>Titulo</th>
                        <th>Status</th>
                        <th>Ações</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($destaques as $destaque)
                        <tr>
                            <td><img src="../uploads/destaques/sm{!! $destaque->foto !!}" class="img-fluid"></td>
                            <td>{!! $destaque->titulo !!}</td>
                            <td>
                                <span class="badge {{ $destaque->statu_id == 1 ? ' badge-success':' badge-warning' }}">{{$destaque->status->nome}}</span>

                            </td>
                            <td>
                                {!! Form::open() !!}
                                <div class="btn-toolbar" role="toolbar">
                                    <div class='btn-group'>
                                        <a title="Adicionar Fotos" href="/admin/destaquesfotos/{{$destaque->id}}"  class='btn btn-sm btn-light'><i class="fa fa-images"></i></a>

                                        <a title="Editar veículo" href="{!! route('admin.destaques.edit', [$destaque->id]) !!}"  class='btn btn-sm btn-light'><i class="fa fa-edit"></i></a>
                                        @if( $destaque->statu_id == 1 )
                                        <a title="Inativar veículo" href="/admin/destaques_inativa/{{base64_encode($destaque->id)}}"
                                           class="btn btn-sm btn-light">
                                            <i class="fas fa-ban"></i>
                                        </a>
                                    @else
                                        <a title="Ativar veículo" href="/admin/destaques_ativa/{{base64_encode($destaque->id)}}"
                                           class="btn btn-sm btn-light">
                                            <i class="far fa-check-circle"></i>
                                        </a>
                                    @endif
                                        <a title="Excluir veículo" href="#" data-bb="confirm" data-text="Tem certeza que deseja excluir este veículo: '{{$destaque->titulo}}'" data-href="/admin/destaques_delete/{{$destaque->id}}" class="btn btn-sm btn-danger"><i class="fas fa-times"></i></a>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4">
                                <center>
                                    <img src="../images/caixa.gif" alt="vazio">
                                Nenhum veículo encontrado.
                                </center>
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

@section('scripts')




    <script type="text/javascript">

        $(document).ready(function() {

            var table =  $('#destaques-table').DataTable( {
                responsive: {
                    details: {
                        display: $.fn.dataTable.Responsive.display.modal( {
                            header: function ( row ) {
                                var data = row.data();
                                return 'Detalhes do '+data[0];
                            }
                        } ),
                        renderer: $.fn.dataTable.Responsive.renderer.tableAll( {
                            tableClass: 'table'
                        } )
                    }
                },
                language: {
                    "url": "/js/pt-br.json",
                },
            });


        } );

    </script>

@endsection
