<?php

namespace App\Repositories;

use App\Models\Admin\Pagina;


/**
 * Class PaginaRepository
 * @package App\Repositories\Admin
 * @version July 4, 2018, 2:24 pm UTC
 *
 * @method Pagina findWithoutFail($id, $columns = ['*'])
 * @method Pagina find($id, $columns = ['*'])
 * @method Pagina first($columns = ['*'])
*/
class PaginaRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'nome',
        'slug',
        'frase',
        'descricao',
        'onmenu',
        'ordem',
        'statu_id',
        'meta_keyword',
        'meta_description'
    ];

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Pagina::class;
    }

    public function findBySlug($slug)
    {
        return Pagina::where('slug',$slug)->with('faqs')->first();
    }





}
