<?php

namespace App\Repositories\Admin;

use App\Models\Admin\Telefone;
use InfyOm\Generator\Common\BaseRepository;
use Carbon\Carbon;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;

/**
 * Class TelefoneRepository
 * @package App\Repositories\Admin
 * @version August 30, 2018, 5:50 pm -03
 *
 * @method Telefone findWithoutFail($id, $columns = ['*'])
 * @method Telefone find($id, $columns = ['*'])
 * @method Telefone first($columns = ['*'])
*/
class TelefoneRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'numero',
        'tipo',
        'link'
    ];

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Telefone::class;
    }

      function create_with_upload ($attributes) {

            $file = $attributes['foto'];
            $attributes['foto'] =  $this->imgUpload($file,'telefones');
            $temporarySkipPresenter = $this->skipPresenter;
            $this->skipPresenter(true);
            $model = parent::create($attributes);
            $this->skipPresenter($temporarySkipPresenter);
            $model = $this->updateRelations($model, $attributes);
            $model->save();

            return $this->parserResult($model);

        }

        public function update_with_upload(array $attributes, $id)
        {

            $telefone = $this->findWithoutFail($id);
            $file = isset ($attributes['foto']) ? $attributes['foto'] : '';
            if(!empty($file)){
                \File::delete(public_path('uploads/telefones/'.$telefone->foto));

                $attributes['foto'] =  $this->imgUpload($file,'telefones');
            }

            // Have to skip presenter to get a model not some data
            $temporarySkipPresenter = $this->skipPresenter;
            $this->skipPresenter(true);
            $model = parent::update($attributes, $id);
            $this->skipPresenter($temporarySkipPresenter);

            $model = $this->updateRelations($model, $attributes);
            $model->save();

            return $this->parserResult($model);
        }

        function destroy_with_upload ($id, $telefone) {
            $imagem = $telefone->foto;
            if ($telefone->destroy($id)) {
                \File::delete(public_path('uploads/telefones/'.$imagem));
            }
        }



        public function imgUpload($file, $path){
            $width= 1300;
            $height=560;

            $file_name = Carbon::now()->timestamp . uniqid().'.'.$file->getClientOriginalExtension();
            $path = 'uploads/'.$path.'/';
            if (!file_exists($path)) {
                File::makeDirectory($path, 0777, true, true);
            }
            Image::make($file)->fit($width, $height)->save($path.$file_name);

            return $file_name;
        }

        public function verificacao(){
            $telefone = Telefone::where('tipo', 'Telefone Principal')->first();
            if($telefone == null){
                return $telefone;

            }
            return $telefone['id'];


        }

        public function replace($id, $numero, $link, $tipo){
            if($tipo == "create"){
                $telefone = Telefone::findOrFail($id);
                $telefone->tipo = "Telefone";
                if($telefone->save()){
                    Telefone::insert([
                        'numero' => $numero,
                        'tipo' => 'Telefone Principal',
                        'link' => $link
                    ]);

                    return true;

                }
            }else{
                $telefone = Telefone::findOrFail($id);
                $telefone->tipo = "Telefone";
                if($telefone->save()){
                    $telefone = Telefone::findOrFail($tipo);
                    $telefone->tipo = "Telefone Principal";
                if($telefone->save()){
                    return true;
                }
                }
            }


            return false;


        }
}
