<?php

namespace App\Repositories\Admin;

use App\Models\Admin\Servico;
use InfyOm\Generator\Common\BaseRepository;
use Carbon\Carbon;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;

/**
 * Class ServicoRepository
 * @package App\Repositories\Admin
 * @version September 3, 2019, 2:53 pm -03
 *
 * @method Servico findWithoutFail($id, $columns = ['*'])
 * @method Servico find($id, $columns = ['*'])
 * @method Servico first($columns = ['*'])
*/
class ServicoRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'nome',
        'subtitulo',
        'descricao',
        'foto',
        'onmenu'
    ];

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Servico::class;
    }

      function create_with_upload ($attributes) {

            $file = $attributes['foto'];
            $attributes['foto'] =  $this->imgUpload($file,'servicos');
            $temporarySkipPresenter = $this->skipPresenter;
            $this->skipPresenter(true);
            $model = parent::create($attributes);
            $this->skipPresenter($temporarySkipPresenter);
            $model = $this->updateRelations($model, $attributes);
            $model->save();

            return $this->parserResult($model);

        }

        public function update_with_upload(array $attributes, $id)
        {

            $servico = $this->findWithoutFail($id);
            $file = isset ($attributes['foto']) ? $attributes['foto'] : '';
            if(!empty($file)){
                \File::delete(public_path('uploads/servicos/'.$servico->foto));
                \File::delete(public_path('uploads/servicos/sm'.$servico->foto));

                $attributes['foto'] =  $this->imgUpload($file,'servicos');
            }

            // Have to skip presenter to get a model not some data
            $temporarySkipPresenter = $this->skipPresenter;
            $this->skipPresenter(true);
            $model = parent::update($attributes, $id);
            $this->skipPresenter($temporarySkipPresenter);

            $model = $this->updateRelations($model, $attributes);
            $model->save();

            return $this->parserResult($model);
        }

        function destroy_with_upload ($id, $servico) {
            $imagem = $servico->foto;
            if ($servico->destroy($id)) {
                \File::delete(public_path('uploads/servicos/'.$imagem));
                \File::delete(public_path('uploads/servicos/sm'.$imagem));
            }
        }


        public function ativar($id)
        {
            $servico = Servico::findOrFail($id);
            $servico->statu_id = 1;
            if ($servico->save()) {
                return true;
            }
            return false;
        }

        public function inativar($id)
        {
           $servico = Servico::findOrFail($id);
           $servico->statu_id = 2;
            if ($servico->save()) {
                return true;
            }
            return false;
        }

        public function imgUpload($file, $path){
            $width= 1300;
            $height=400;

            $file_name = Carbon::now()->timestamp . uniqid().'.'.$file->getClientOriginalExtension();
            $path = 'uploads/'.$path.'/';                  if (!file_exists($path)) {             File::makeDirectory($path, 0777, true, true);         }
            Image::make($file)->resize($width, $height)->save($path.$file_name);
            Image::make($file)->resize($width/6, $height/6)->save($path.'sm'.$file_name);

            return $file_name;
        }

    public function verificaSlug($slug){

        $post = Servico::where('slug', '=', $slug)->first();

        if ($post)
            return true;
        else
            return false;
    }

    public function findBySlug($slug)
    {
        return Servico::where('slug',$slug)->with('servicosfotos')->first();
    }
}
