<?php

namespace App\Repositories\Admin;

use App\Models\Admin\Pergunta;
use InfyOm\Generator\Common\BaseRepository;
use Carbon\Carbon;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;

/**
 * Class PerguntaRepository
 * @package App\Repositories\Admin
 * @version September 3, 2019, 7:32 pm -03
 *
 * @method Pergunta findWithoutFail($id, $columns = ['*'])
 * @method Pergunta find($id, $columns = ['*'])
 * @method Pergunta first($columns = ['*'])
*/
class PerguntaRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'pergunta',
        'resposta',
        'faq_id'
    ];

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Pergunta::class;
    }

      function create_with_upload ($attributes) {

            $file = $attributes['foto'];
            $attributes['foto'] =  $this->imgUpload($file,'perguntas');
            $temporarySkipPresenter = $this->skipPresenter;
            $this->skipPresenter(true);
            $model = parent::create($attributes);
            $this->skipPresenter($temporarySkipPresenter);
            $model = $this->updateRelations($model, $attributes);
            $model->save();

            return $this->parserResult($model);

        }

        public function update_with_upload(array $attributes, $id)
        {

            $pergunta = $this->findWithoutFail($id);
            $file = isset ($attributes['foto']) ? $attributes['foto'] : '';
            if(!empty($file)){
                \File::delete(public_path('uploads/perguntas/'.$pergunta->foto));
                \File::delete(public_path('uploads/perguntas/sm'.$pergunta->foto));

                $attributes['foto'] =  $this->imgUpload($file,'perguntas');
            }

            // Have to skip presenter to get a model not some data
            $temporarySkipPresenter = $this->skipPresenter;
            $this->skipPresenter(true);
            $model = parent::update($attributes, $id);
            $this->skipPresenter($temporarySkipPresenter);

            $model = $this->updateRelations($model, $attributes);
            $model->save();

            return $this->parserResult($model);
        }

        function destroy_with_upload ($id, $pergunta) {
            $imagem = $pergunta->foto;
            if ($pergunta->destroy($id)) {
                \File::delete(public_path('uploads/perguntas/'.$imagem));
                \File::delete(public_path('uploads/perguntas/sm'.$imagem));
            }
        }


        public function ativar($id)
        {
            $pergunta = Pergunta::findOrFail($id);
            $pergunta->statu_id = 1;
            if ($pergunta->save()) {
                return true;
            }
            return false;
        }

        public function inativar($id)
        {
           $pergunta = Pergunta::findOrFail($id);
           $pergunta->statu_id = 2;
            if ($pergunta->save()) {
                return true;
            }
            return false;
        }

        public function imgUpload($file, $path){
            $width= 1300;
            $height=560;

            $file_name = Carbon::now()->timestamp . uniqid().'.'.$file->getClientOriginalExtension();
            $path = 'uploads/'.$path.'/';                  if (!file_exists($path)) {             File::makeDirectory($path, 0777, true, true);         }
            Image::make($file)->resize($width, $height)->save($path.$file_name);
            Image::make($file)->resize($width/6, $height/6)->save($path.'sm'.$file_name);

            return $file_name;
        }
}
