<?php

namespace App\Repositories\Admin;

use App\Models\Admin\Pagina;
use InfyOm\Generator\Common\BaseRepository;
use Carbon\Carbon;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;

/**
 * Class PaginaRepository
 * @package App\Repositories\Admin
 * @version July 4, 2018, 2:24 pm UTC
 *
 * @method Pagina findWithoutFail($id, $columns = ['*'])
 * @method Pagina find($id, $columns = ['*'])
 * @method Pagina first($columns = ['*'])
 */
class PaginaRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'nome',
        'slug',
        'descricao',
        'onmenu',
        'ordem',
        'statu_id',
        'meta_keyword',
        'meta_description',
        'youtube',
        'banner',
        'foto'
    ];

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Pagina::class;
    }

    function create_with_upload ($attributes) {

        $file = $attributes['foto'];
        $attributes['foto'] =  $this->imgUpload($file,'paginas');
        $temporarySkipPresenter = $this->skipPresenter;
        $this->skipPresenter(true);
        $model = parent::create($attributes);
        $this->skipPresenter($temporarySkipPresenter);
        $model = $this->updateRelations($model, $attributes);
        $model->save();

        return $this->parserResult($model);

    }

    public function update_with_upload(array $attributes, $id)
    {

        $pagina = $this->findWithoutFail($id);
        $file = isset ($attributes['foto']) ? $attributes['foto'] : '';
        if(!empty($file)){
            \File::delete(public_path('uploads/paginas/'.$pagina->foto));
            \File::delete(public_path('uploads/paginas/sm'.$pagina->foto));

            $attributes['foto'] =  $this->imgUpload($file,'paginas');
        }

        // Have to skip presenter to get a model not some data
        $temporarySkipPresenter = $this->skipPresenter;
        $this->skipPresenter(true);
        $model = parent::update($attributes, $id);
        $this->skipPresenter($temporarySkipPresenter);

        $model = $this->updateRelations($model, $attributes);
        $model->save();

        return $this->parserResult($model);
    }

    function destroy_with_upload ($id, $pagina) {
        $imagem = $pagina->foto;
        if ($pagina->destroy($id)) {
            \File::delete(public_path('uploads/paginas/'.$imagem));
            \File::delete(public_path('uploads/paginas/sm'.$imagem));
        }
    }

    public function imgUpload($file, $path){
        $width= 1300;
        $height=400;

        $file_name = Carbon::now()->timestamp . uniqid().'.'.$file->getClientOriginalExtension();
        $path = 'uploads/'.$path.'/';
        if (!file_exists($path)) {
            File::makeDirectory($path, 0777, true, true);         }
        Image::make($file)->resize($width, $height)->save($path.$file_name);

        return $file_name;
    }

    public function ativar($id)
    {
        $pagina = Pagina::findOrFail($id);
        $pagina->statu_id = 1;
        if ($pagina->save()) {
            return true;
        }
        return false;
    }

    public function inativar($id)
    {
        $pagina = Pagina::findOrFail($id);
        $pagina->statu_id = 2;
        if ($pagina->save()) {
            return true;
        }
        return false;
    }

    public function verificaSlug($slug){

        $pagina = Pagina::where('slug', '=', $slug)->first();

        if ($pagina)
            return true;
        else
            return false;
    }



    public function paginaSelectbox(){
        return Pagina::orderBy('nome')->pluck('nome', 'id')->toarray();
    }

}
