<?php

namespace App\Repositories\Admin;

use App\Models\Admin\Noticia;
use InfyOm\Generator\Common\BaseRepository;
use Carbon\Carbon;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;

/**
 * Class NoticiaRepository
 * @package App\Repositories\Admin
 * @version March 25, 2019, 7:08 pm -03
 *
 * @method Noticia findWithoutFail($id, $columns = ['*'])
 * @method Noticia find($id, $columns = ['*'])
 * @method Noticia first($columns = ['*'])
*/
class NoticiaRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'icone',
        'titulo',
        'descricao',
        'link',
        'statu_id'
    ];

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Noticia::class;
    }

      function create_with_upload ($attributes) {

            $file = $attributes['icone'];
            list($width, $height) = getimagesize($file);

            $attributes['icone'] =  $this->imgUpload($file,'noticias', $width, $height);
            $temporarySkipPresenter = $this->skipPresenter;
            $this->skipPresenter(true);
            $model = parent::create($attributes);
            $this->skipPresenter($temporarySkipPresenter);
            $model = $this->updateRelations($model, $attributes);
            $model->save();

            return $this->parserResult($model);

        }

        public function update_with_upload(array $attributes, $id)
        {

            $noticia = $this->findWithoutFail($id);
            $file = isset ($attributes['icone']) ? $attributes['icone'] : '';
            if(!empty($file)){
                \File::delete(public_path('uploads/noticias/'.$noticia->icone));

                list($width, $height) = getimagesize($file);

                $attributes['icone'] =  $this->imgUpload($file,'noticias', $width, $height);
            }

            // Have to skip presenter to get a model not some data
            $temporarySkipPresenter = $this->skipPresenter;
            $this->skipPresenter(true);
            $model = parent::update($attributes, $id);
            $this->skipPresenter($temporarySkipPresenter);

            $model = $this->updateRelations($model, $attributes);
            $model->save();

            return $this->parserResult($model);
        }

        function destroy_with_upload ($id) {
            $noticia = $this->findWithoutFail($id);

            $imagem = $noticia->icone;
            if ($noticia->destroy($id)) {
                \File::delete(public_path('uploads/noticias/'.$imagem));
            }
        }


        public function imgUpload($file, $path, $width, $height){



            $file_name = Carbon::now()->timestamp . uniqid().'.'.$file->getClientOriginalExtension();
            $path = 'uploads/'.$path.'/';
            if (!file_exists($path)) {
                File::makeDirectory($path, 0777, true, true);
            }
            Image::make($file)->fit($width, $height)->save($path.$file_name);

            return $file_name;
        }

        public function ativar($id)
        {
            $noticia = Noticia::findOrFail($id);
            $noticia->statu_id = 1;
            if ($noticia->save()) {
                return true;
            }
            return false;
        }

        public function inativar($id)
        {
           $noticia = Noticia::findOrFail($id);
           $noticia->statu_id = 2;
            if ($noticia->save()) {
                return true;
            }
            return false;
        }
}
