<?php

namespace App\Repositories\Admin;

use App\Models\Admin\Integracao;
use InfyOm\Generator\Common\BaseRepository;
use Carbon\Carbon;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;

/**
 * Class IntegracoeRepository
 * @package App\Repositories\Admin
 * @version March 29, 2023,5:54 pm UTC
 *
 * @method Integracao findWithoutFail($id, $columns = ['*'])
 * @method Banner find($id, $columns = ['*'])
 * @method Banner first($columns = ['*'])
*/
class IntegracoeRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'head',
        'abertura',
        'fechamento'
    ];

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Integracao::class;
    }

    function create_with_upload($attributes) {


        $temporarySkipPresenter = $this->skipPresenter;
        $this->skipPresenter(true);
        $model = parent::create($attributes);
        $this->skipPresenter($temporarySkipPresenter);
        $model = $this->updateRelations($model, $attributes);
        $model->save();

        return $this->parserResult($model);

    }

    public function update_with_upload(array $attributes, $id)
    {
        $config = $this->findWithoutFail($id);
        $file = isset ($attributes['banner']) ? $attributes['banner'] : '';
        if(!empty($file)){
            \File::delete(public_path('uploads/configuracoes/'.$config->banner));

            $attributes['banner'] =  $this->imgUpload($file,'configuracoes',1920,400);
        }

        $file = isset ($attributes['banner_pt']) ? $attributes['banner_pt'] : '';
        if(!empty($file)){
            \File::delete(public_path('uploads/configuracoes/'.$config->banner_pt));

            $attributes['banner_pt'] =  $this->imgUpload($file,'configuracoes',1920,400);
        }

        $foto = isset ($attributes['foto']) ? $attributes['foto'] : '';
        if(!empty($foto)){
            \File::delete(public_path('uploads/configuracoes/'.$config->foto));

            $attributes['foto'] =  $this->imgUpload($foto,'configuracoes',1070,750);
        }

        // Have to skip presenter to get a model not some data
        $temporarySkipPresenter = $this->skipPresenter;
        $this->skipPresenter(true);
        $model = parent::update($attributes, $id);
        $this->skipPresenter($temporarySkipPresenter);

        $model = $this->updateRelations($model, $attributes);
        $model->save();

        return $this->parserResult($model);
    }


    public function imgUpload($file, $path,$width,$height){


        $file_name = Carbon::now()->timestamp . uniqid().'.'.$file->getClientOriginalExtension();
        $path = 'uploads/'.$path.'/';

        if (!file_exists($path)) {
            File::makeDirectory($path, 0777, true, true);
        }

        Image::make($file)->fit($width, $height)->save($path.$file_name);

        return $file_name;
    }
}
