<?php

namespace App\Repositories\Admin;

use App\Models\Admin\Destaquefoto;
use InfyOm\Generator\Common\BaseRepository;
use Carbon\Carbon;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;

/**
 * Class DestaquesfotoRepository
 * @package App\Repositories\Admin
 * @version September 3, 2019, 3:28 pm -03
 *
 * @method Destaquefoto findWithoutFail($id, $columns = ['*'])
 * @method Destaquefoto find($id, $columns = ['*'])
 * @method Destaquefoto first($columns = ['*'])
*/
class DestaquesfotoRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'titulo',
        'foto',
        'ordem',
        'destaque_id'
    ];

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Destaquefoto::class;
    }

      function create_with_upload ($attributes) {

            $file = $attributes['foto'];
            $attributes['foto'] =  $this->imgUpload($file,'destaquesfotos');
            $temporarySkipPresenter = $this->skipPresenter;
            $this->skipPresenter(true);
            $model = parent::create($attributes);
            $this->skipPresenter($temporarySkipPresenter);
            $model = $this->updateRelations($model, $attributes);
            $model->save();

            return $this->parserResult($model);

        }

        public function update_with_upload(array $attributes, $id)
        {

            $destaquefoto = $this->findWithoutFail($id);
            $file = isset ($attributes['foto']) ? $attributes['foto'] : '';
            if(!empty($file)){
                \File::delete(public_path('uploads/destaquesfotos/'.$destaquefoto->foto));
                \File::delete(public_path('uploads/destaquesfotos/sm'.$destaquefoto->foto));

                $attributes['foto'] =  $this->imgUpload($file,'destaquesfotos');
            }

            // Have to skip presenter to get a model not some data
            $temporarySkipPresenter = $this->skipPresenter;
            $this->skipPresenter(true);
            $model = parent::update($attributes, $id);
            $this->skipPresenter($temporarySkipPresenter);

            $model = $this->updateRelations($model, $attributes);
            $model->save();

            return $this->parserResult($model);
        }

        function destroy_with_upload ($id, $destaquefoto) {
            $imagem = $destaquefoto->foto;
            if ($destaquefoto->destroy($id)) {
                \File::delete(public_path('uploads/destaquesfotos/'.$imagem));
                \File::delete(public_path('uploads/destaquesfotos/sm'.$imagem));
            }
        }


        public function imgUpload($file, $path){
            $width= 800;
            $height=600;

            $file_name = Carbon::now()->timestamp . uniqid().'.'.$file->getClientOriginalExtension();
            $path = 'uploads/'.$path.'/';
            if (!file_exists($path)) {
                File::makeDirectory($path, 0777, true, true);
            }
            Image::make($file)->resize($width, $height)->save($path.$file_name);
            Image::make($file)->resize(200, 133)->save($path.'sm'.$file_name);

            return $file_name;
        }
}
