<?php

namespace App\Repositories\Admin;

use App\Models\Admin\Configuracoe;
use InfyOm\Generator\Common\BaseRepository;
use Carbon\Carbon;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;

/**
 * Class ConfiguracoeRepository
 * @package App\Repositories\Admin
 * @version June 28, 2018, 8:13 pm UTC
 *
 * @method Configuracoe findWithoutFail($id, $columns = ['*'])
 * @method Configuracoe find($id, $columns = ['*'])
 * @method Configuracoe first($columns = ['*'])
*/
class ConfiguracoeRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'nome_aplicacao',
        'email',
        'meta_keyword',
        'meta_description',
        'facebook',
        'instagram',
        'twitter',
        'linkedin',
        'youtube',
        'funcionamento',
        'logorodape',
        'login',
        'manutencao',
        'mapa',
        'loja'

    ];

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Configuracoe::class;
    }

    function create_with_upload ($attributes) {


        if(!empty($attributes['logo'])) {
            $logo = $attributes['logo'];

            list($width, $height) = getimagesize($logo);

            $attributes['logo'] = $this->imgUpload($logo,'configuracoes',$width,$height);
        }

        if(!empty($attributes['logorodape'])) {
            $logorodape = $attributes['logorodape'];

            list($width, $height) = getimagesize($logorodape);

            $attributes['logorodape'] = $this->imgUpload($logorodape,'configuracoes',$width,$height);
        }

        if(!empty($attributes['login'])) {
            $login = $attributes['login'];

            list($width, $height) = getimagesize($login);

            $attributes['login'] = $this->imgUpload($login,'configuracoes',$width,$height);
        }


        $temporarySkipPresenter = $this->skipPresenter;
        $this->skipPresenter(true);
        $model = parent::create($attributes);
        $this->skipPresenter($temporarySkipPresenter);
        $model = $this->updateRelations($model, $attributes);
        $model->save();

        return $this->parserResult($model);

    }

    public function update_with_upload(array $attributes, $id)
    {
        $config = $this->findWithoutFail($id);

        $logo = isset ($attributes['logo']) ? $attributes['logo'] : '';
        if(!empty($logo)){
            \File::delete(public_path('uploads/configuracoes/'.$config->logo));

            list($width, $height) = getimagesize($logo);

            $attributes['logo'] =  $this->imgUpload($logo,'configuracoes',$width, $height);
        }

        $logorodape = isset ($attributes['logorodape']) ? $attributes['logorodape'] : '';
        if(!empty($logorodape)){
            \File::delete(public_path('uploads/configuracoes/'.$config->logorodape));

            list($width, $height) = getimagesize($logorodape);

            $attributes['logorodape'] =  $this->imgUpload($logorodape,'configuracoes',$width,$height);
        }

        $login = isset ($attributes['login']) ? $attributes['login'] : '';
        if(!empty($login)){
            \File::delete(public_path('uploads/configuracoes/'.$config->login));

            list($width, $height) = getimagesize($login);

            $attributes['login'] =  $this->imgUpload($login,'configuracoes',$width,$height);
        }


        // Have to skip presenter to get a model not some data
        $temporarySkipPresenter = $this->skipPresenter;
        $this->skipPresenter(true);
        $model = parent::update($attributes, $id);
        $this->skipPresenter($temporarySkipPresenter);

        $model = $this->updateRelations($model, $attributes);
        $model->save();

        return $this->parserResult($model);
    }


    public function imgUpload($file, $path,$width,$height){


        $file_name = Carbon::now()->timestamp . uniqid().'.'.$file->getClientOriginalExtension();

        $path = 'uploads/'.$path.'/';
        if (!file_exists($path)) {
            File::makeDirectory($path, 0777, true, true);
        }

        Image::make($file)->fit($width, $height)->save($path.$file_name);

        return $file_name;
    }

    public function manutencao(array $attributes, $id)
    {
        $config = $this->findWithoutFail($id);

        $temporarySkipPresenter = $this->skipPresenter;
        $this->skipPresenter(true);
        $model = parent::update($attributes, $id);
        $this->skipPresenter($temporarySkipPresenter);

        $model = $this->updateRelations($model, $attributes);
        $model->save();

        return $this->parserResult($model);
    }
}
