<?php

namespace App\Repositories\Admin;

use App\Models\Admin\Bloco;
use InfyOm\Generator\Common\BaseRepository;
use Carbon\Carbon;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;

/**
 * Class BlocoRepository
 * @package App\Repositories\Admin
 * @version March 25, 2019, 7:08 pm -03
 *
 * @method Bloco findWithoutFail($id, $columns = ['*'])
 * @method Bloco find($id, $columns = ['*'])
 * @method Bloco first($columns = ['*'])
*/
class BlocoRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'icone',
        'titulo',
        'texto',
        'title',
        'text'
    ];

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Bloco::class;
    }

      function create_with_upload ($attributes) {

            $file = $attributes['icone'];
            list($width, $height) = getimagesize($file);

            $attributes['icone'] =  $this->imgUpload($file,'blocos', $width, $height);
            $temporarySkipPresenter = $this->skipPresenter;
            $this->skipPresenter(true);
            $model = parent::create($attributes);
            $this->skipPresenter($temporarySkipPresenter);
            $model = $this->updateRelations($model, $attributes);
            $model->save();

            return $this->parserResult($model);

        }

        public function update_with_upload(array $attributes, $id)
        {

            $bloco = $this->findWithoutFail($id);
            $file = isset ($attributes['icone']) ? $attributes['icone'] : '';
            if(!empty($file)){
                \File::delete(public_path('uploads/blocos/'.$bloco->icone));

                list($width, $height) = getimagesize($file);

                $attributes['icone'] =  $this->imgUpload($file,'blocos', $width, $height);
            }

            // Have to skip presenter to get a model not some data
            $temporarySkipPresenter = $this->skipPresenter;
            $this->skipPresenter(true);
            $model = parent::update($attributes, $id);
            $this->skipPresenter($temporarySkipPresenter);

            $model = $this->updateRelations($model, $attributes);
            $model->save();

            return $this->parserResult($model);
        }

        function destroy_with_upload ($id) {
            $bloco = $this->findWithoutFail($id);

            $imagem = $bloco->icone;
            if ($bloco->destroy($id)) {
                \File::delete(public_path('uploads/blocos/'.$imagem));
            }
        }


        public function imgUpload($file, $path, $width, $height){



            $file_name = Carbon::now()->timestamp . uniqid().'.'.$file->getClientOriginalExtension();
            $path = 'uploads/'.$path.'/';
            if (!file_exists($path)) {
                File::makeDirectory($path, 0777, true, true);
            }
            Image::make($file)->fit($width, $height)->save($path.$file_name);

            return $file_name;
        }

        public function tipoSelectbox(){
            return Bloco::pluck('titulo', 'id');
        }

}
