<?php

namespace App\Repositories\Admin;

use App\Models\Admin\Banner;
use InfyOm\Generator\Common\BaseRepository;
use Carbon\Carbon;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;


/**
 * Class BannerRepository
 * @package App\Repositories\Admin
 * @version June 29, 2018, 1:02 pm UTC
 *
 * @method Banner findWithoutFail($id, $columns = ['*'])
 * @method Banner find($id, $columns = ['*'])
 * @method Banner first($columns = ['*'])
 */
class BannerRepository extends BaseRepository
{

    /**
     * @var array
     */
    protected $fieldSearchable = [
        'titulo',
        'foto',
        'url',
        'ordem',
        'statu_id'
    ];

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Banner::class;
    }

    function create_with_upload ($attributes) {


        if(!empty($attributes['foto'])) {
            $foto = $attributes['foto'];
            $attributes['foto'] =  $this->imgUpload($foto,'banners');
        }

        if(!empty($attributes['foto_pt'])) {
            $foto_pt = $attributes['foto_pt'];
            $attributes['foto_pt'] =  $this->imgUpload($foto_pt,'banners');
        }

        $temporarySkipPresenter = $this->skipPresenter;
        $this->skipPresenter(true);
        $model = parent::create($attributes);
        $this->skipPresenter($temporarySkipPresenter);
        $model = $this->updateRelations($model, $attributes);
        $model->save();

        return $this->parserResult($model);

    }

    public function update_with_upload(array $attributes, $id)
    {

        $banner = $this->findWithoutFail($id);
        $foto = isset ($attributes['foto']) ? $attributes['foto'] : '';
        if(!empty($foto)){
            \File::delete(public_path('uploads/banners/'.$banner->foto));
            \File::delete(public_path('uploads/banners/sm'.$banner->foto));

            $attributes['foto'] =  $this->imgUpload($foto,'banners');
        }

        $foto_pt = isset ($attributes['foto_pt']) ? $attributes['foto_pt'] : '';
        if(!empty($foto_pt)){
            \File::delete(public_path('uploads/banners/'.$banner->foto_pt));
            \File::delete(public_path('uploads/banners/sm'.$banner->foto_pt));

            $attributes['foto_pt'] =  $this->imgUpload($foto_pt,'banners');
        }

        // Have to skip presenter to get a model not some data
        $temporarySkipPresenter = $this->skipPresenter;
        $this->skipPresenter(true);
        $model = parent::update($attributes, $id);
        $this->skipPresenter($temporarySkipPresenter);

        $model = $this->updateRelations($model, $attributes);
        $model->save();

        return $this->parserResult($model);
    }

    function destroy_with_upload ($id, $banner) {
        $foto = !empty($banner->foto) ?$banner->foto : '';
        $foto_pt = !empty($banner->foto_pt) ?$banner->foto_pt : '';

        if ($banner->destroy($id)) {
            if(!empty($foto)) {
                \File::delete(public_path('uploads/banners/' . $foto));
                \File::delete(public_path('uploads/banners/sm' . $foto));
            }
            if(!empty($foto_pt)) {
                \File::delete(public_path('uploads/banners/' . $foto_pt));
                \File::delete(public_path('uploads/banners/sm' . $foto_pt));
            }
        }
    }


    public function ativar($id)
    {
        $banner = Banner::findOrFail($id);
        $banner->statu_id = 1;
        if ($banner->save()) {
            return true;
        }
        return false;
    }

    public function inativar($id)
    {
        $banner = Banner::findOrFail($id);
        $banner->statu_id = 2;
        if ($banner->save()) {
            return true;
        }
        return false;
    }

    public function imgUpload($file, $path){
        $width= 1920;
        $height=750;

        $file_name = Carbon::now()->timestamp . uniqid().'.'.$file->getClientOriginalExtension();
        $path = 'uploads/'.$path.'/';

        if (!file_exists($path)) {
            File::makeDirectory($path, 0777, true, true);
        }

        Image::make($file)->fit($width, $height)->save($path.$file_name);
        Image::make($file)->fit(intval($width/6), intval($height/6))->save($path.'sm'.$file_name);

        return $file_name;
    }

}
