<?php

namespace App\Models\Admin;

use Eloquent as Model;

/**
 * Class Servicosfoto
 * @package App\Models\Admin
 * @version September 3, 2019, 2:41 pm -03
 *
 * @property string titulo
 * @property string foto
 * @property integer ordem
 * @property integer servico_id
 */
class Servicosfoto extends Model
{

    public $table = 'servicosfotos';


    public $fillable = [
        'titulo',
        'foto',
        'ordem',
        'servico_id'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'titulo' => 'string',
        'foto' => 'string',
        'ordem' => 'integer',
        'servico_id' => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'foto' => 'image|mimes:jpeg,png,jpg,webp|max:5242880'
    ];

    public function servicos(){
        return $this->belongsTo('App\Servico', 'servico_id');
    }
}
