<?php

namespace App\Models\Admin;

use Eloquent as Model;

/**
 * Class Pagina
 * @package App\Models\Admin
 * @version September 3, 2019, 6:54 pm -03
 *
 * @property string nome
 * @property string slug
 * @property string descricao
 * @property integer onmenu
 * @property integer pagina_id
 * @property integer ordem
 * @property integer statu_id
 * @property string meta_keyword
 * @property string meta_description
 */
class Pagina extends Model
{

    public $table = 'paginas';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';

    public $fillable = [
        'nome',
        'slug',
        'descricao',
        'onmenu',
        'ordem',
        'statu_id',
        'meta_keyword',
        'meta_description',
        'youtube',
        'banner',
        'foto'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'nome' => 'string',
        'slug' => 'string',
        'descricao' => 'string',
        'onmenu' => 'integer',
        'pagina_id' => 'integer',
        'ordem' => 'integer',
        'statu_id' => 'integer',
        'meta_keyword' => 'string',
        'meta_description' => 'string',
        'onfooter' => 'integer',
        'subtitulo' => 'string',
        'foto' => 'string',
        'youtube' => 'string',
        'banner' => 'string'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'foto' => 'image|mimes:jpeg,png,jpg,webp|max:5242880',
        'banner' => 'image|mimes:jpeg,png,jpg,webp|max:5242880'

    ];

    public function status(){
        return $this->belongsTo('App\Statu', 'statu_id');
    }

    public function paginas()
    {
        return $this->hasMany('App\Models\Admin\Pagina','pagina_id');
    }

    public function faqs()
    {
        return $this->hasMany('App\Models\Admin\Faq','pagina_id')->with('perguntas');
    }


}
