<?php

namespace App\Models\Admin;

use Eloquent as Model;

/**
 * Class Noticia
 * @package App\Models\Admin
 * @version March 25, 2019, 7:08 pm -03
 *
 * @property \Illuminate\Database\Eloquent\Collection
 * @property \Illuminate\Database\Eloquent\Collection
 * @property string icone
 * @property string titulo
 * @property string texto
 * @property string title
 * @property string text
 */
class Noticia extends Model
{

    public $table = 'noticias';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';



    public $fillable = [
        'icone',
        'titulo',
        'descricao',
        'link',
        'statu_id'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'icone' => 'string',
        'titulo' => 'string',
        'descricao' => 'string',
        'link' => 'string',
        'statu_id' => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'titulo' => 'required',
        'icone' => 'image|mimes:jpeg,png,jpg,webp|max:5242880',

    ];

    public function status(){
        return $this->belongsTo('App\Statu', 'statu_id');
    }
}
