<?php

namespace App\Models\Admin;

use Eloquent as Model;

/**
 * Class Destaque
 * @package App\Models\Admin
 * @version August 26, 2019, 7:12 pm -03
 *
 * @property string titulo
 * @property string foto
 * @property string link
 * @property string informacoes
 */
class Destaque extends Model
{

    public $table = 'destaques';



    public $fillable = [
        'titulo',
        'foto',
        'tipo_id',
        'informacoes',
        'statu_id',
        'destaque',
        'youtube',
        'valor',
        'marca',
        'modelo',
        'carroceria',
        'chassi',
        'ano',
        'direcao',
        'lugares',
        'ar',
        'portas',
        'combustivel'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'titulo' => 'string',
        'foto' => 'string',
        'tipo_id' => 'integer',
        'informacoes' => 'string',
        'statu_id' => 'integer',
        'destaque' => 'integer',
        'youtube' => 'string',
        'valor' => 'string',
        'marca' => 'string',
        'modelo' => 'string',
        'carroceria' => 'string',
        'chassi' => 'string',
        'ano' => 'string',
        'direcao' => 'string',
        'lugares' => 'integer',
        'ar' => 'string',
        'portas' => 'integer',
        'combustivel' => 'string'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'foto' => 'image|mimes:jpeg,png,jpg,webp|max:5242880',
        'titulo' => 'required'
    ];

    public function destaquesfotos(){
        return $this->hasMany('App\Models\Admin\destaquefotos', 'destaque_id');
    }

    public function status(){
        return $this->belongsTo('App\Statu', 'statu_id');
    }
}
