<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Banner
 * @package App\Models\Admin
 * @version June 29, 2018, 1:02 pm UTC
 *
 * @property string titulo
 * @property string foto
 * @property string url
 * @property integer ordem
 * @property integer statu_id
 */
class Banner extends Model
{

    public $table = 'banners';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';



    public $fillable = [
        'titulo',
        'foto',
        'url',
        'ordem',
        'statu_id'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'titulo' => 'string',
        'foto' => 'string',
        'url' => 'string',
        'ordem' => 'integer',
        'statu_id' => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'foto' => 'image|mimes:jpeg,png,jpg,webp|max:5242880'
    ];

    public function status(){
        return $this->belongsTo('App\Statu', 'statu_id');
    }

}
