<?php

namespace App\Http\Controllers;


use App\Repositories\Admin\ConfiguracoeRepository;
use App\Repositories\PaginaRepository;
use App\Repositories\Admin\BlocoRepository;
use Illuminate\Contracts\Auth\Guard;
use Illuminate\Support\Facades\Request;
use App\Services\MailService;
use Illuminate\Support\Facades\Session;

class PaginaController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(PaginaRepository $paginaRepository, ConfiguracoeRepository $configuracoeRepository, BlocoRepository $blocoRepository)
    {
        $this->paginaRepository = $paginaRepository;
        $this->configuracoeRepository = $configuracoeRepository;
        $this->blocoRepository = $blocoRepository;

    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function ver($slug)
    {
        $pagina =  $this->paginaRepository->findBySlug($slug);
        $blocos = $this->blocoRepository->orderBy('ordem', 'asc')->all();

        if (isset($pagina)) {

            return view('paginas.ver',compact('pagina','blocos'));
        } else {
            return redirect(route('home'));
        }

    }

    public function fale_conosco()
    {
        return view('paginas.contato_pt');
    }


    public function contato_envia(MailService $mailService)
    {
        $input = Request::all();

        if(!filter_var($input['contatoEmail'], FILTER_VALIDATE_EMAIL)){
            die('{"Status":"FAIL","Message":"Digite um email válido"}');
        }

        $configuracoes = $this->configuracoeRepository->findWithoutFail(1);

        if($mailService->emailContato('contato', $input, $configuracoes)){
            session_start();
            unset($_SESSION['qaptcha_key']);
            die('{"Status":"DONE","Message":"Contato realizado com sucesso! Responderemos em breve."}');
        }else{
            die('{"Status":"FAIL","Message":"Erro ao realizar contato, tente novamente mais tarde."}');
        }

    }

    public function trabalhe_conosco()
    {
        return view('paginas.trabalheconosco');
    }

    public function trabalhe_envia(MailService $mailService)
    {
        $input = Request::all();

        if(!filter_var($input['contatoEmail'], FILTER_VALIDATE_EMAIL)){
            die('{"Status":"FAIL","Message":"Digite um email válido"}');
        }

        $configuracoes = $this->configuracoeRepository->findWithoutFail(1);

        if($mailService->emailTrabalhe('trabalhe', $input, $configuracoes)){
            session_start();
            unset($_SESSION['qaptcha_key']);
//            die("Enviado com sucesso");
            die('{"Status":"DONE","Message":"Contato realizado com sucesso! Responderemos em breve."}');
        }else{
            die('{"Status":"FAIL","Message":"Erro ao realizar contato, tente novamente mais tarde."}');
        }

    }


}
