<?php

namespace App\Http\Controllers;

use App\Repositories\Admin\BannerRepository;
use App\Repositories\Admin\BannersinternoRepository;
use App\Repositories\Admin\BlocoRepository;
use App\Repositories\Admin\DestaqueRepository;
use App\Repositories\Admin\HomeRepository;
use App\Models\Admin\Configuracoe;
use Illuminate\Contracts\Auth\Guard;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(BannerRepository $bannerRepository, BannersinternoRepository $bannersinternoRepository, BlocoRepository $blocoRepository, DestaqueRepository $destaqueRepository, HomeRepository $homeRepository)
    {
        $this->bannerRepository = $bannerRepository;
        $this->bannersinternoRepository = $bannersinternoRepository;
        $this->blocoRepository = $blocoRepository;
        $this->destaqueRepository = $destaqueRepository;
        $this->homeRepository = $homeRepository;
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $banners = $this->bannerRepository->findWhere(['statu_id' => 1]);
        $blocos = $this->blocoRepository->orderBy('ordem', 'asc')->all();
        $destaques = $this->destaqueRepository->findWhere(['destaque' => 1]);
        $home = $this->homeRepository->findWithoutFail(1);
        $bannersinterno = $this->bannersinternoRepository->findWithoutFail(1);
        $config = Configuracoe::findOrFail(1);

        if($config['manutencao'] == 0 ||  $config['manutencao'] == null){

            return view('home.home',compact('banners','bannersinterno',  'blocos', 'destaques', 'home'));

        }else{

            return view('manutencao');

        }

    }

    }


