<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

use App\Repositories\AvisoRepository;

class AvisoController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {

    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index(AvisoRepository $avisoRepository)
    {

        $img = $avisoRepository->select();
        $img = $img->imagem;
        return view('aviso', compact('img'));
    }

    public function store(Request $request, AvisoRepository $avisoRepository)
    {

        $request->validate([
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:5242880',
        ]);

        $name = 'aviso.'.$request->image->extension();

        if ($request->hasFile('image')) {

            $nome = $avisoRepository->saveImg($name);
         }
        $request->image->move(public_path('aviso_orions'), $name);
        $img = $avisoRepository->select();
        $img = $img->imagem;
        return back()->with('success','Imagem salva com sucesso.')->with('image',$name)->with('img', $img);



    }
}
