<?php

namespace App\Http\Controllers;

use App\Repositories\Admin\BannerRepository;
use App\Repositories\Admin\PaginaRepository;
use App\Repositories\Admin\UserRepository;
use App\Repositories\Admin\ConfiguracoeRepository;

use Illuminate\Http\Request;

class AdminController extends Controller
{
      /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(  BannerRepository $bannerRepository, PaginaRepository $paginaRepository,  UserRepository $userRepository, ConfiguracoeRepository $configuracoeRepository)
    {
        $this->bannerRepository = $bannerRepository;
        $this->paginaRepository = $paginaRepository;
        $this->userRepository = $userRepository;
        $this->configuracoeRepository = $configuracoeRepository;

        $this->middleware('auth');
    }

     /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $banner = $this->bannerRepository->all()->count();
        $pagina = $this->paginaRepository->all()->count();
        $user = $this->userRepository->findWhere(['role_id' => 1])->count();
        $configuracoe = $this->configuracoeRepository->findWithoutFail(1);

        return view('admin.home',compact('banner','pagina','user','configuracoe'));
    }
}

