<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\CreateTelefoneRequest;
use App\Http\Requests\Admin\UpdateTelefoneRequest;
use App\Repositories\Admin\TelefoneRepository;
use App\Http\Controllers\AppBaseController;
use App\Services\AuxiliarService;
use Illuminate\Http\Request;
use Flash;
use Prettus\Repository\Criteria\RequestCriteria;
use Response;

class TelefoneController extends AppBaseController
{
    /** @var  TelefoneRepository */
    private $telefoneRepository;

    public function __construct(TelefoneRepository $telefoneRepo, AuxiliarService $auxiliarService)
    {
        $this->telefoneRepository = $telefoneRepo;
        $this->auxiliarService = $auxiliarService;
    }

    /**
     * Display a listing of the Telefone.
     *
     * @param Request $request
     * @return Response
     */
    public function index(Request $request)
    {
        $this->telefoneRepository->pushCriteria(new RequestCriteria($request));
        $telefones = $this->telefoneRepository->all();

        return view('admin.telefones.index')
            ->with('telefones', $telefones);
    }

    /**
     * Show the form for creating a new Telefone.
     *
     * @return Response
     */
    public function create()
    {
        return view('admin.telefones.create');
    }

    /**
     * Store a newly created Telefone in storage.
     *
     * @param CreateTelefoneRequest $request
     *
     * @return Response
     */
    public function store(CreateTelefoneRequest $request)
    {
        $input = $request->all();
        $input['link'] = $this->auxiliarService->limpatelefone($input['numero']);
        $telefone = $this->telefoneRepository->verificacao();


        if($telefone == null){
            $telefone = $this->telefoneRepository->create($input);
            Flash::success('Telefone salvo com sucesso.');
            return redirect(route('admin.telefones.index'));

        }else{
            $numero = $input['numero'];
            $verificacao = 1;
            $tipo = 'create';

            return view('admin.telefones.create', compact('verificacao', 'numero','tipo'));

        }



    }

    /**
     * Display the specified Telefone.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $telefone = $this->telefoneRepository->findWithoutFail($id);

        if (empty($telefone)) {
            Flash::error('Telefone não encontrado');

            return redirect(route('admin.telefones.index'));
        }

        return view('admin.telefones.show')->with('telefone', $telefone);
    }

    /**
     * Show the form for editing the specified Telefone.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $telefone = $this->telefoneRepository->findWithoutFail($id);

        if (empty($telefone)) {
            Flash::error('Telefone não encontrado');

            return redirect(route('admin.telefones.index'));
        }

        return view('admin.telefones.edit')->with('telefone', $telefone);
    }

    /**
     * Update the specified Telefone in storage.
     *
     * @param  int              $id
     * @param UpdateTelefoneRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateTelefoneRequest $request)
    {
        $telefone = $this->telefoneRepository->findWithoutFail($id);

        if (empty($telefone)) {
            Flash::error('Telefone não encontrado');

            return redirect(route('admin.telefones.index'));
        }

        $input = $request->all();

        $input['link'] = $this->auxiliarService->limpatelefone($input['numero']);
        $verificando = $this->telefoneRepository->verificacao();


        if($verificando == null){
            $telefone = $this->telefoneRepository->update($input, $id);
            Flash::success('Telefone editado com sucesso.');
            return redirect(route('admin.telefones.index'));

        }else{
            $numero = $input['numero'];
            $verificacao = 1;
            $tipo = $telefone->id;
            return view('admin.telefones.edit', compact('verificacao', 'numero','telefone','tipo'));

        }



    }

    /**
     * Remove the specified Telefone from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $telefone = $this->telefoneRepository->findWithoutFail($id);

        if (empty($telefone)) {
            Flash::error('Telefone não encontrado');

            return redirect(route('admin.telefones.index'));
        }

        $this->telefoneRepository->delete($id);

        Flash::success('Telefone deletado com sucesso.');

        return redirect(route('admin.telefones.index'));
    }

      public function ativar($id)
        {
            $id = base64_decode($id);
            $this->telefoneRepository->ativar($id);
            Flash::success('Telefone ativado com sucesso.');
            return redirect(route('admin.telefones.index'));
        }

        public function inativar($id)
        {
            $id = base64_decode($id);
            $this->telefoneRepository->inativar($id);
            Flash::success('Telefone inativado com sucesso.');
            return redirect(route('admin.telefones.index'));
        }

        public function replace($numero, $tipo)
    {

        $verificacao = $this->telefoneRepository->verificacao();
        $link = $this->auxiliarService->limpatelefone($numero);

        $telefone = $this->telefoneRepository->replace($verificacao, $numero, $link, $tipo);

        if ($telefone == false) {
            Flash::error('Erro ao tentar substituir o telefone principal.');

            if ($telefone != null) {
                $verificacao = 1;
            }

            return view('admin.telefones.create', compact('numero', 'verificacao'));
        }

        Flash::success('Telefone principal substituido com sucesso.');

        return redirect(route('admin.telefones.index'));
    }
}
