<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\CreateIntegracoesRequest;
use App\Http\Requests\Admin\UpdateIntegracoesRequest;
use App\Repositories\Admin\IntegracoeRepository;
use App\Http\Controllers\AppBaseController;
use Illuminate\Http\Request;
use Flash;
use Prettus\Repository\Criteria\RequestCriteria;
use Response;

class IntegracoesController extends AppBaseController
{
    /** @var  IntegracoeRepository */
    private $integracoeRepository;

    public function __construct(IntegracoeRepository $integracoeRepository)
    {
        $this->integracoeRepository = $integracoeRepository;
    }

    /**
     * Display a listing of the integracoe.
     *
     * @param Request $request
     * @return Response
     */
    public function index(Request $request)
    {
        $this->integracoeRepository->pushCriteria(new RequestCriteria($request));
        $integracoes = $this->integracoeRepository->all();

        return view('admin.integracoes.edit')
            ->with('integracoes', $integracoes);
    }

    /**
     * Show the form for creating a new integracoe.
     *
     * @return Response
     */
    public function create()
    {
        return view('admin.integracoes.create');
    }

    /**
     * Store a newly created integracoe in storage.
     *
     * @param CreateIntegracoesRequest $request
     *
     * @return Response
     */
    public function store(CreateIntegracoesRequest $request)
    {
        $input = $request->all();
        $input['id'] = 1;

        $integracoe = $this->integracoeRepository->create_with_upload($input);


        Flash::success('Integrações salva com sucesso.');

        return redirect(route('admin.integracoes.edit'));
    }



    /**
     * Show the form for editing the specified integracoe.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit()
    {
        $integracoe = $this->integracoeRepository->findWithoutFail(1);

        if (empty($integracoe)) {
            return redirect(route('admin.integracoes.create'));
        }

        return view('admin.integracoes.edit')->with('integracoe', $integracoe);
    }

    /**
     * Update the specified integracoe in storage.
     *
     * @param  int              $id
     * @param UpdateIntegracoesRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateIntegracoesRequest $request)
    {
        $integracoe = $this->integracoeRepository->findWithoutFail($id);

        if (empty($integracoe)) {
            Flash::error('integracoe not found');

            return redirect(route('admin.integracoes.edit'));
        }

        $input = $request->all();
        $input['id'] = 1;


        $integracoe = $this->integracoeRepository->update_with_upload($input, $id);

        Flash::success('Configuracão editada com sucesso.');

        return redirect(route('admin.integracoes.edit'));
    }

    /**
     * Remove the specified integracoe from storage.
     *
     * @param  int $id
     *
     * @return Response
     */

}
