<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\CreateFaqRequest;
use App\Http\Requests\Admin\UpdateFaqRequest;
use App\Repositories\Admin\FaqRepository;
use App\Http\Controllers\AppBaseController;
use App\Repositories\Admin\PaginaRepository;
use Illuminate\Http\Request;
use Flash;
use Prettus\Repository\Criteria\RequestCriteria;
use Response;

class FaqController extends AppBaseController
{
    /** @var  FaqRepository */
    private $faqRepository;

    public function __construct(FaqRepository $faqRepo, PaginaRepository $paginaRepository)
    {
        $this->faqRepository = $faqRepo;
        $this->paginaRepository = $paginaRepository;
    }

    /**
     * Display a listing of the Faq.
     *
     * @param Request $request
     * @return Response
     */
    public function index(Request $request)
    {
        $this->faqRepository->pushCriteria(new RequestCriteria($request));

        $faqs = $this->faqRepository->with('paginas')->all();

        return view('admin.faqs.index')
            ->with('faqs', $faqs);
    }

    /**
     * Show the form for creating a new Faq.
     *
     * @return Response
     */
    public function create()
    {
        $paginas = $this->paginaRepository->paginaSelectbox();
        return view('admin.faqs.create', compact('paginas'));
    }

    /**
     * Store a newly created Faq in storage.
     *
     * @param CreateFaqRequest $request
     *
     * @return Response
     */
    public function store(CreateFaqRequest $request)
    {
        $input = $request->all();

        $faq = $this->faqRepository->create($input);

        Flash::success('Faq salvo(a) com sucesso.');

        return redirect(route('admin.faqs.index'));
    }

    /**
     * Display the specified Faq.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $faq = $this->faqRepository->findWithoutFail($id);

        if (empty($faq)) {
            Flash::error('Faq não encontrado(a)');

            return redirect(route('admin.faqs.index'));
        }

        return view('admin.faqs.show')->with('faq', $faq);
    }

    /**
     * Show the form for editing the specified Faq.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $faq = $this->faqRepository->findWithoutFail($id);

        if (empty($faq)) {
            Flash::error('Faq não encontrado(a)');

            return redirect(route('admin.faqs.index'));
        }
        $paginas = $this->paginaRepository->paginaSelectbox();
        return view('admin.faqs.edit', compact('paginas'))->with('faq', $faq);
    }

    /**
     * Update the specified Faq in storage.
     *
     * @param  int              $id
     * @param UpdateFaqRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateFaqRequest $request)
    {
        $faq = $this->faqRepository->findWithoutFail($id);

        if (empty($faq)) {
            Flash::error('Faq não encontrado(a)');

            return redirect(route('admin.faqs.index'));
        }

        $faq = $this->faqRepository->update($request->all(), $id);

        Flash::success('Faq editado(a) com sucesso.');

        return redirect(route('admin.faqs.index'));
    }

    /**
     * Remove the specified Faq from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $faq = $this->faqRepository->findWithoutFail($id);

        if (empty($faq)) {
            Flash::error('Faq não encontrado(a)');

            return redirect(route('admin.faqs.index'));
        }

        $this->faqRepository->delete($id);

        Flash::success('Faq deletado(a) com sucesso.');

        return redirect(route('admin.faqs.index'));
    }

      public function ativar($id)
        {
            $id = base64_decode($id);
            $this->faqRepository->ativar($id);
            Flash::success('Faq ativado(a) com sucesso.');
            return redirect(route('admin.faqs.index'));
        }

        public function inativar($id)
        {
            $id = base64_decode($id);
            $this->faqRepository->inativar($id);
            Flash::success('Faq inativado(a) com sucesso.');
            return redirect(route('admin.faqs.index'));
        }

}
