<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\CreateDestaquesfotoRequest;
use App\Http\Requests\Admin\UpdateDestaquesfotoRequest;
use App\Repositories\Admin\DestaqueRepository;
use App\Repositories\Admin\DestaquesfotoRepository;
use App\Http\Controllers\AppBaseController;
use Illuminate\Http\Request;
use Flash;
use Prettus\Repository\Criteria\RequestCriteria;
use Response;

class DestaquesfotoController extends AppBaseController
{
    /** @var  DestaquesfotoRepository */
    private $sestaquesfotoRepository;

    public function __construct(DestaquesfotoRepository $destaquesfotoRepo, DestaqueRepository $destaqueRepository)
    {
        $this->destaquesfotoRepository = $destaquesfotoRepo;
        $this->destaqueRepository = $destaqueRepository;
        $this->statuRepository = $statuRepository;

    }

    /**
     * Display a listing of the Destaquesfoto.
     *
     * @param Request $request
     * @return Response
     */
    public function index($destaque_id, Request $request)
    {
        $this->destaquesfotoRepository->pushCriteria(new RequestCriteria($request));
        $destaquesfotos = $this->destaquesfotoRepository->findWhere(['destaque_id' => $destaque_id]);
        $destaque = $this->destaqueRepository->find($destaque_id, ['titulo', 'id']);

        return view('admin.destaquesfotos.index')
            ->with('destaquesfotos', $destaquesfotos)
            ->with('destaque', $destaque)
            ->with('destaque_id', $destaque_id);

    }

    /**
     * Show the form for creating a new Destaquesfoto.
     *
     * @return Response
     */
    public function create($destaque_id)
    {
        return view('admin.destaquesfotos.create', compact('destaque_id'));
    }

    /**
     * Store a newly created Destaquesfoto in storage.
     *
     * @param CreateDestaquesfotoRequest $request
     *
     * @return Response
     */
    public function store(CreateDestaquesfotoRequest $request)
    {
        ini_set('memory_limit', '-1');
        $input = $request->all();
        if (isset($input['qqfilename'])){
            $input['titulo'] = $input['qqfilename'];
            $input['foto'] = $input['qqfile'];
        }
$destaque_id = $input['destaque_id'];
        $destaquesfotos = $this->destaquesfotoRepository->create_with_upload($input);

        if(isset($input['qqfilename'])){
            if($destaquesfotos){
                die('{"success":true}');
            } else {
                die('{"error": "Erro ao tentar cadastrar esta foto, tente novamente!"}');
            }
        }


        Flash::success('Fotos do veículo salvo(a)s com sucesso.');

        return redirect('/admin/destaquesfotos/'.$destaque_id);
    }

    /**
     * Display the specified Destaquesfoto.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $destaquesfotos = $this->destaquesfotoRepository->findWithoutFail($id);

        if (empty($destaquesfotos)) {
            Flash::error('foto não encontrado(a)');

            return redirect(route('admin.destaquesfotos.index'));
        }

        return view('admin.destaquesfotos.show')->with('destaquesfoto', $destaquesfotos);
    }

    /**
     * Show the form for editing the specified Destaquesfoto.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($destaque_id, $id)
    {
        $destaquesfoto = $this->destaquesfotoRepository->findWithoutFail($id);
        $destaque = $this->destaqueRepository->find($destaque_id, ['titulo', 'id']);
        if (empty($destaquesfoto)) {
            Flash::error('foto não encontrado(a)');

            return redirect(route('admin.destaquesfotos.index'));
        }

        return view('admin.destaquesfotos.edit')->with('destaquesfoto', $destaquesfoto)->with('destaque', $destaque)->with('destaque_id', $destaque_id);
    }

    /**
     * Update the specified Destaquesfoto in storage.
     *
     * @param  int              $id
     * @param UpdateDestaquesfotoRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateDestaquesfotoRequest $request)
    {
        $destaquefoto = $this->destaquefotoRepository->findWithoutFail($id);

        if (empty($destaquefoto)) {
            Flash::error('Foto não encontrado(a)');

            return redirect(route('admin.destaquefotos.index'));
        }

        $destaquefoto = $this->destaquefotoRepository->update($request->all(), $id);

        Flash::success('Foto editado(a) com sucesso.');

        return redirect('/admin/destaquefotos/'.$destaquefoto->destaque_id);


    }

    /**
     * Remove the specified Destaquesfoto from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $destaquefoto = $this->destaquesfotoRepository->findWithoutFail($id);

        if (empty($destaquefoto)) {
            Flash::error('foto não encontrado(a)');

            return redirect(route('admin.destaquefotos.index'));
        }

        $this->destaquesfotoRepository->delete($id);

        Flash::success('foto deletado(a) com sucesso.');

        return redirect('/admin/destaquesfotos/'.$destaquefoto->destaque_id);
    }

      public function ativar($id)
        {
            $id = base64_decode($id);
            $this->destaquesfotoRepository->ativar($id);
            Flash::success('foto ativado(a) com sucesso.');
            return redirect(route('admin.destaquesfotos.index'));
        }

        public function inativar($id)
        {
            $id = base64_decode($id);
            $this->destaquesfotoRepository->inativar($id);
            Flash::success('foto inativado(a) com sucesso.');
            return redirect(route('admin.destaquesfoto.index'));
        }

}
