<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\CreateDestaqueRequest;
use App\Http\Requests\Admin\UpdateDestaqueRequest;
use App\Repositories\Admin\DestaqueRepository;
use App\Repositories\Admin\BlocoRepository;
use App\Repositories\StatuRepository;

use App\Http\Controllers\AppBaseController;
use Illuminate\Http\Request;
use Flash;
use Prettus\Repository\Criteria\RequestCriteria;
use Response;

class DestaqueController extends AppBaseController
{
    /** @var  DestaqueRepository */
    private $destaqueRepository;

    public function __construct(DestaqueRepository $destaqueRepo, BlocoRepository $blocoRepository, StatuRepository $statuRepository)
    {
        $this->destaqueRepository = $destaqueRepo;
        $this->blocoRepository = $blocoRepository;
        $this->statuRepository = $statuRepository;

    }

    /**
     * Display a listing of the Destaque.
     *
     * @param Request $request
     * @return Response
     */
    public function index(Request $request)
    {
        $this->destaqueRepository->pushCriteria(new RequestCriteria($request));
        $destaques = $this->destaqueRepository->all();

        return view('admin.destaques.index')
            ->with('destaques', $destaques);
    }

    /**
     * Show the form for creating a new Destaque.
     *
     * @return Response
     */
    public function create()
    {

        $tipos = $this->blocoRepository->tipoSelectbox();
        $status = $this->statuRepository->statuSelectbox();

        return view('admin.destaques.create', compact('tipos','status'));
    }

    /**
     * Store a newly created Destaque in storage.
     *
     * @param CreateDestaqueRequest $request
     *
     * @return Response
     */
    public function store(CreateDestaqueRequest $request)
    {
        $input = $request->all();

        $destaque = $this->destaqueRepository->create_with_upload($input);

        Flash::success('Veículo salvo(a) com sucesso.');

        return redirect(route('admin.destaques.index'));
    }

    /**
     * Display the specified Destaque.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $destaque = $this->destaqueRepository->findWithoutFail($id);

        if (empty($destaque)) {
            Flash::error('Veículo não encontrado(a)');

            return redirect(route('admin.destaques.index'));
        }

        return view('admin.destaques.show')->with('destaque', $destaque);
    }

    /**
     * Show the form for editing the specified Destaque.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $destaque = $this->destaqueRepository->findWithoutFail($id);
        $tipos = $this->blocoRepository->tipoSelectbox();
        $status = $this->statuRepository->statuSelectbox();

        if (empty($destaque)) {
            Flash::error('Veículo não encontrado(a)');

            return redirect(route('admin.destaques.index'));
        }

        return view('admin.destaques.edit')->with('destaque', $destaque)->with('tipos', $tipos)->with('status', $status);
    }

    /**
     * Update the specified Destaque in storage.
     *
     * @param  int              $id
     * @param UpdateDestaqueRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateDestaqueRequest $request)
    {
        $destaque = $this->destaqueRepository->findWithoutFail($id);

        if (empty($destaque)) {
            Flash::error('Veículo não encontrado(a)');

            return redirect(route('admin.destaques.index'));
        }

        $destaque = $this->destaqueRepository->update_with_upload($request->all(), $id);

        Flash::success('Veículo editado(a) com sucesso.');

        return redirect(route('admin.destaques.index'));
    }

    /**
     * Remove the specified Destaque from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $destaque = $this->destaqueRepository->findWithoutFail($id);

        if (empty($destaque)) {
            Flash::error('Veículo não encontrado(a)');

            return redirect(route('admin.destaques.index'));
        }

        $this->destaqueRepository->delete($id);

        Flash::success('Veículo deletado(a) com sucesso.');

        return redirect(route('admin.destaques.index'));
    }

      public function ativar($id)
        {
            $id = base64_decode($id);
            $this->destaqueRepository->ativar($id);
            Flash::success('Veículo ativado(a) com sucesso.');
            return redirect(route('admin.destaques.index'));
        }

        public function inativar($id)
        {
            $id = base64_decode($id);
            $this->destaqueRepository->inativar($id);
            Flash::success('Veículo inativado(a) com sucesso.');
            return redirect(route('admin.destaques.index'));
        }

}
