<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\CreateConfiguracoeRequest;
use App\Http\Requests\Admin\UpdateConfiguracoeRequest;
use App\Repositories\Admin\ConfiguracoeRepository;
use App\Http\Controllers\AppBaseController;
use Illuminate\Http\Request;
use Flash;
use Prettus\Repository\Criteria\RequestCriteria;
use Response;

class ConfiguracoeController extends AppBaseController
{
    /** @var  ConfiguracoeRepository */
    private $configuracoeRepository;

    public function __construct(ConfiguracoeRepository $configuracoeRepo)
    {
        $this->configuracoeRepository = $configuracoeRepo;
    }

    /**
     * Display a listing of the Configuracoe.
     *
     * @param Request $request
     * @return Response
     */
    public function index(Request $request)
    {
        $this->configuracoeRepository->pushCriteria(new RequestCriteria($request));
        $configuracoes = $this->configuracoeRepository->all();

        return view('admin.configuracoes.edit')
            ->with('configuracoes', $configuracoes);
    }

    /**
     * Show the form for creating a new Configuracoe.
     *
     * @return Response
     */
    public function create()
    {
        return view('admin.configuracoes.create');
    }

    /**
     * Store a newly created Configuracoe in storage.
     *
     * @param CreateConfiguracoeRequest $request
     *
     * @return Response
     */
    public function store(CreateConfiguracoeRequest $request)
    {
        $input = $request->all();
        $input['id'] = 1;


        $configuracoe = $this->configuracoeRepository->create_with_upload($input);

        Flash::success('Configuração salva com sucesso.');

        return redirect(route('admin.configuracoes.edit')->with('image',$name)->with('img', $img));
    }



    /**
     * Show the form for editing the specified Configuracoe.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit()
    {
        $configuracoe = $this->configuracoeRepository->findWithoutFail(1);

        if (empty($configuracoe)) {
            return redirect(route('admin.configuracoes.create'));
        }

        return view('admin.configuracoes.edit')->with('configuracoe', $configuracoe);
    }

    /**
     * Update the specified Configuracoe in storage.
     *
     * @param  int              $id
     * @param UpdateConfiguracoeRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateConfiguracoeRequest $request)
    {
        $configuracoe = $this->configuracoeRepository->findWithoutFail($id);

        if (empty($configuracoe)) {
            Flash::error('Configuracoe not found');

            return redirect(route('admin.configuracoes.edit'));
        }

        $input = $request->all();
        $input['id'] = 1;


        $configuracoe = $this->configuracoeRepository->update_with_upload($input, $id);

        Flash::success('Configuracão editada com sucesso.');

        return redirect(route('admin.configuracoes.edit'));
    }

    public function manutencao($id, UpdateConfiguracoeRequest $request)
    {
        $configuracoe = $this->configuracoeRepository->findWithoutFail($id);

        if (empty($configuracoe)) {
            Flash::error('Configuracoe not found');

            return redirect(route('admin.configuracoes.edit'));
        }

        if($configuracoe->manutencao == 0 || $configuracoe->manutencao == null ){
            $input['manutencao'] = 1;
        }else{
            $input['manutencao'] = 0;
        }


        $configuracoe = $this->configuracoeRepository->manutencao($input, $id);


        return redirect('/admin');
    }

}
