<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\CreateBannersinternoRequest;
use App\Http\Requests\Admin\UpdateBannersinternoRequest;
use App\Repositories\Admin\BannersinternoRepository;
use App\Http\Controllers\AppBaseController;
use Illuminate\Http\Request;
use Flash;
use Prettus\Repository\Criteria\RequestCriteria;
use Response;

class BannersinternoController extends AppBaseController
{
    /** @var  BannersinternoRepository */
    private $bannersinternoRepository;

    public function __construct(BannersinternoRepository $bannersinternoRepo)
    {
        $this->bannersinternoRepository = $bannersinternoRepo;
    }

    /**
     * Display a listing of the Bannersinterno.
     *
     * @param Request $request
     * @return Response
     */
    public function index(Request $request)
    {
        $this->bannersinternoRepository->pushCriteria(new RequestCriteria($request));
        $bannersinternos = $this->bannersinternoRepository->all();

        return view('admin.bannersinternos.index')
            ->with('bannersinternos', $bannersinternos);
    }

    /**
     * Show the form for creating a new Bannersinterno.
     *
     * @return Response
     */
    public function create()
    {
        return view('admin.bannersinternos.create');
    }

    /**
     * Store a newly created Bannersinterno in storage.
     *
     * @param CreateBannersinternoRequest $request
     *
     * @return Response
     */
    public function store(CreateBannersinternoRequest $request)
    {
        $input = $request->all();

        $bannersinterno = $this->bannersinternoRepository->create_with_upload($input);

        Flash::success('Banners salvos com sucesso.');

        return redirect(route('admin.bannersinternos.edit'));
    }

    /**
     * Display the specified Bannersinterno.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $bannersinterno = $this->bannersinternoRepository->findWithoutFail($id);

        if (empty($bannersinterno)) {
            Flash::error('Banners não encontrados');

            return redirect(route('admin.bannersinternos.index'));
        }

        return view('admin.bannersinternos.show')->with('bannersinterno', $bannersinterno);
    }

    /**
     * Show the form for editing the specified Bannersinterno.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit()
    {
        $bannersinterno = $this->bannersinternoRepository->findWithoutFail(1);

        if (empty($bannersinterno)) {
            return redirect(route('admin.bannersinternos.create'));
        }

        return view('admin.bannersinternos.edit')->with('bannersinterno', $bannersinterno);
    }

    /**
     * Update the specified Bannersinterno in storage.
     *
     * @param  int              $id
     * @param UpdateBannersinternoRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateBannersinternoRequest $request)
    {
        $bannersinterno = $this->bannersinternoRepository->findWithoutFail($id);

        if (empty($bannersinterno)) {
            Flash::error('Banners não encontrado(a)');

            return redirect(route('admin.bannersinternos.edit'));
        }

        $input = $request->all();
        $input['id'] = 1;
        $bannersinterno = $this->bannersinternoRepository->update_with_upload($input, $id);

        Flash::success('Banners editados com sucesso.');

        return redirect(route('admin.bannersinternos.edit'));
    }

    /**
     * Remove the specified Bannersinterno from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $bannersinterno = $this->bannersinternoRepository->findWithoutFail($id);

        if (empty($bannersinterno)) {
            Flash::error('Bannersinterno não encontrado(a)');

            return redirect(route('admin.bannersinternos.index'));
        }

        $this->bannersinternoRepository->delete($id);

        Flash::success('Bannersinterno deletado(a) com sucesso.');

        return redirect(route('admin.bannersinternos.index'));
    }

      public function ativar($id)
        {
            $id = base64_decode($id);
            $this->bannersinternoRepository->ativar($id);
            Flash::success('Bannersinterno ativado(a) com sucesso.');
            return redirect(route('admin.bannersinternos.index'));
        }

        public function inativar($id)
        {
            $id = base64_decode($id);
            $this->bannersinternoRepository->inativar($id);
            Flash::success('Bannersinterno inativado(a) com sucesso.');
            return redirect(route('admin.bannersinternos.index'));
        }

}
