<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\CreateBannerRequest;
use App\Http\Requests\Admin\UpdateBannerRequest;
use App\Repositories\Admin\BannerRepository;
use App\Http\Controllers\AppBaseController;
use App\Repositories\StatuRepository;
use Illuminate\Http\Request;
use Flash;
use Prettus\Repository\Criteria\RequestCriteria;
use Response;
use Illuminate\Support\Facades\Validator;

class BannerController extends AppBaseController
{
    /** @var  BannerRepository */
    private $bannerRepository;

    public function __construct(BannerRepository $bannerRepo, StatuRepository $statuRepository)
    {
        $this->bannerRepository = $bannerRepo;
        $this->statuRepository = $statuRepository;
    }

    /**
     * Display a listing of the Banner.
     *
     * @param Request $request
     * @return Response
     */
    public function index(Request $request)
    {
        $this->bannerRepository->pushCriteria(new RequestCriteria($request));
        $banners = $this->bannerRepository->with('status')->all();
        return view('admin.banners.index')->with('banners', $banners);
    }

    /**
     * Show the form for creating a new Banner.
     *
     * @return Response
     */
    public function create()
    {
        $status = $this->statuRepository->statuSelectbox();
        return view('admin.banners.create',compact('status'));
    }

    /**
     * Store a newly created Banner in storage.
     *
     * @param CreateBannerRequest $request
     *
     * @return Response
     */
    public function store(CreateBannerRequest $request)
    {
        $input = $request->all();


        $banner = $this->bannerRepository->create_with_upload($input);

        Flash::success('Banner salvo com sucesso.');

        return redirect(route('admin.banners.index'));
    }

    /**
     * Display the specified Banner.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $banner = $this->bannerRepository->findWithoutFail($id);

        if (empty($banner)) {
            Flash::error('Banner não encontrado');

            return redirect(route('admin.banners.index'));
        }

        return view('admin.banners.show')->with('banner', $banner);
    }

    /**
     * Show the form for editing the specified Banner.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $banner = $this->bannerRepository->findWithoutFail($id);

        if (empty($banner)) {
            Flash::error('Banner não encontrado');

            return redirect(route('admin.banners.index'));
        }

        $status = $this->statuRepository->statuSelectbox();

        return view('admin.banners.edit',compact('status'))->with('banner', $banner);
    }

    /**
     * Update the specified Banner in storage.
     *
     * @param  int              $id
     * @param UpdateBannerRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateBannerRequest $request)
    {
        $banner = $this->bannerRepository->findWithoutFail($id);

        if (empty($banner)) {
            Flash::error('Banner não encontrado');

            return redirect(route('admin.banners.index'));
        }

        $banner = $this->bannerRepository->update_with_upload($request->all(), $id);

        Flash::success('Banner editado com sucesso.');

        return redirect(route('admin.banners.index'));
    }

    /**
     * Remove the specified Banner from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {

        $banner = $this->bannerRepository->findWithoutFail($id);

        if (empty($banner)) {
            Flash::error('Banner não encontrado');

            return redirect(route('admin.banners.index'));
        }

        $this->bannerRepository->destroy_with_upload($id,$banner);

        Flash::success('Banner deletado com sucesso');

        return redirect(route('admin.banners.index'));
    }

    public function ativar($id)
    {
        $id = base64_decode($id);
        $this->bannerRepository->ativar($id);
        Flash::success('Banner ativado com sucesso');
        return redirect(route('admin.banners.index'));
    }

    public function inativar($id)
    {
        $id = base64_decode($id);
        $this->bannerRepository->inativar($id);
        Flash::success('Banner inativado com sucesso');
        return redirect(route('admin.banners.index'));
    }



}
